/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.hitbtc;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import info.bitrich.xchangestream.core.StreamingMarketDataService;
import info.bitrich.xchangestream.hitbtc.HitbtcStreamingService;
import info.bitrich.xchangestream.hitbtc.dto.HitbtcWebSocketOrderBook;
import info.bitrich.xchangestream.hitbtc.dto.HitbtcWebSocketOrderBookTransaction;
import info.bitrich.xchangestream.hitbtc.dto.HitbtcWebSocketTickerTransaction;
import info.bitrich.xchangestream.hitbtc.dto.HitbtcWebSocketTradeParams;
import info.bitrich.xchangestream.hitbtc.dto.HitbtcWebSocketTradesTransaction;
import info.bitrich.xchangestream.service.netty.StreamingObjectMapperHelper;
import io.reactivex.Observable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.hitbtc.v2.HitbtcAdapters;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcOrderBook;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcTicker;

public class HitbtcStreamingMarketDataService
implements StreamingMarketDataService {
    private final HitbtcStreamingService service;
    private Map<CurrencyPair, HitbtcWebSocketOrderBook> orderbooks = new HashMap<CurrencyPair, HitbtcWebSocketOrderBook>();

    public HitbtcStreamingMarketDataService(HitbtcStreamingService service) {
        this.service = service;
    }

    public Observable<OrderBook> getOrderBook(CurrencyPair currencyPair, Object ... args) {
        String pair = currencyPair.base.toString() + currencyPair.counter.toString();
        String channelName = this.getChannelName("orderbook", pair);
        ObjectMapper mapper = StreamingObjectMapperHelper.getObjectMapper();
        Observable jsonNodeObservable = this.service.subscribeChannel(channelName, new Object[0]);
        return jsonNodeObservable.map(s -> (HitbtcWebSocketOrderBookTransaction)mapper.treeToValue((TreeNode)s, HitbtcWebSocketOrderBookTransaction.class)).map(s -> {
            HitbtcWebSocketOrderBook hitbtcOrderBook = s.toHitbtcOrderBook(this.orderbooks.getOrDefault(currencyPair, null));
            this.orderbooks.put(currencyPair, hitbtcOrderBook);
            return HitbtcAdapters.adaptOrderBook((HitbtcOrderBook)hitbtcOrderBook.toHitbtcOrderBook(), (CurrencyPair)currencyPair);
        });
    }

    public Observable<Trade> getTrades(CurrencyPair currencyPair, Object ... args) {
        String pair = currencyPair.base.toString() + currencyPair.counter.toString();
        String channelName = this.getChannelName("trades", pair);
        ObjectMapper mapper = StreamingObjectMapperHelper.getObjectMapper();
        return this.service.subscribeChannel(channelName, new Object[0]).map(s -> (HitbtcWebSocketTradesTransaction)mapper.treeToValue((TreeNode)s, HitbtcWebSocketTradesTransaction.class)).map(HitbtcWebSocketTradesTransaction::getParams).filter(Objects::nonNull).map(HitbtcWebSocketTradeParams::getData).filter(Objects::nonNull).map(Arrays::asList).flatMapIterable(s -> {
            Trades adaptedTrades = HitbtcAdapters.adaptTrades((List)s, (CurrencyPair)currencyPair);
            return adaptedTrades.getTrades();
        });
    }

    public Observable<Ticker> getTicker(CurrencyPair currencyPair, Object ... args) {
        String pair = currencyPair.base.toString() + currencyPair.counter.toString();
        String channelName = this.getChannelName("ticker", pair);
        ObjectMapper mapper = StreamingObjectMapperHelper.getObjectMapper();
        return this.service.subscribeChannel(channelName, new Object[0]).map(s -> (HitbtcWebSocketTickerTransaction)mapper.treeToValue((TreeNode)s, HitbtcWebSocketTickerTransaction.class)).map(s -> HitbtcAdapters.adaptTicker((HitbtcTicker)s.getParams(), (CurrencyPair)currencyPair));
    }

    private String getChannelName(String entityName, String pair) {
        return entityName + "-" + pair;
    }
}

