/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.gemini.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.instrument.Instrument;

public class GeminiWebSocketTransaction {
    private String type;
    private String symbol;
    private String[][] changes;
    private JsonNode trades;
    private JsonNode auctionEvents;

    public GeminiWebSocketTransaction(@JsonProperty(value="type") String type, @JsonProperty(value="symbol") String symbol, @JsonProperty(value="changes") String[][] changes, @JsonProperty(value="trades") JsonNode trades, @JsonProperty(value="auction_events") JsonNode auctionEvents) {
        this.type = type;
        this.symbol = symbol;
        this.changes = changes;
        this.trades = trades;
        this.auctionEvents = auctionEvents;
    }

    public String getType() {
        return this.type;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String[][] getChanges() {
        return this.changes;
    }

    public JsonNode getTrades() {
        return this.trades;
    }

    public JsonNode getAuctionEvents() {
        return this.auctionEvents;
    }

    private List<LimitOrder> geminiOrderBookChanges(String side, Order.OrderType orderType, CurrencyPair currencyPair, String[][] changes, SortedMap<BigDecimal, BigDecimal> sideEntries, int maxDepth) {
        if (changes.length == 0) {
            return Collections.emptyList();
        }
        if (sideEntries == null) {
            return Collections.emptyList();
        }
        for (String[] level2 : changes) {
            if (level2.length == 3 && !level2[0].equals(side)) continue;
            BigDecimal price = new BigDecimal(level2[level2.length - 2]);
            BigDecimal volume = new BigDecimal(level2[level2.length - 1]);
            sideEntries.put(price, volume);
        }
        Stream<Map.Entry> stream = sideEntries.entrySet().stream().filter(level -> ((BigDecimal)level.getValue()).compareTo(BigDecimal.ZERO) != 0);
        if (maxDepth != 0) {
            stream = stream.limit(maxDepth);
        }
        return stream.map(level -> new LimitOrder(orderType, (BigDecimal)level.getValue(), (Instrument)currencyPair, "0", null, (BigDecimal)level.getKey())).collect(Collectors.toList());
    }

    public OrderBook toOrderBook(SortedMap<BigDecimal, BigDecimal> bids, SortedMap<BigDecimal, BigDecimal> asks, int maxDepth, CurrencyPair currencyPair) {
        List<LimitOrder> orderBookBids = this.geminiOrderBookChanges("buy", Order.OrderType.BID, currencyPair, this.changes != null ? this.changes : null, bids, maxDepth);
        List<LimitOrder> orderBookAsks = this.geminiOrderBookChanges("sell", Order.OrderType.ASK, currencyPair, this.changes != null ? this.changes : null, asks, maxDepth);
        return new OrderBook(null, orderBookAsks, orderBookBids, false);
    }
}

