/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.gemini.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import info.bitrich.xchangestream.core.ProductSubscription;
import java.util.ArrayList;
import org.knowm.xchange.instrument.Instrument;

public class GeminiWebSocketSubscriptionMessage {
    private static final String L2 = "l2";
    private static final String CANDLES_1M = "candles_1m";
    private static final String CANDLES_5M = "candles_5m";
    private static final String CANDLES_15M = "candles_15m";
    private static final String CANDLES_30M = "candles_30m";
    private static final String CANDLES_1H = "candles_1h";
    private static final String CANDLES_6H = "candles_6h";
    private static final String CANDLES_1D = "candles_1d";
    @JsonProperty(value="type")
    public final String type;
    @JsonProperty(value="subscriptions")
    public final Subscription[] subscriptions;

    public GeminiWebSocketSubscriptionMessage(String type, ProductSubscription productSubscription) {
        this.type = type;
        this.subscriptions = this.constructSubscriptions(productSubscription);
    }

    private Subscription[] constructSubscriptions(ProductSubscription productSubscription) {
        if (productSubscription == null) {
            return null;
        }
        ArrayList<Subscription> subscriptions = new ArrayList<Subscription>();
        ArrayList<String> L2Symbols = new ArrayList<String>();
        for (Instrument currencyPair : productSubscription.getOrderBook()) {
            L2Symbols.add(currencyPair.getBase().toString() + currencyPair.getCounter().toString());
        }
        subscriptions.add(new Subscription(L2, L2Symbols.toArray(new String[0])));
        return subscriptions.toArray(new Subscription[0]);
    }

    public class Subscription {
        @JsonProperty(value="name")
        public final String name;
        @JsonProperty(value="symbols")
        public final String[] symbols;

        public Subscription(String name, String[] symbols) {
            this.name = name;
            this.symbols = symbols;
        }
    }
}

