/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.gemini;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import info.bitrich.xchangestream.core.ProductSubscription;
import info.bitrich.xchangestream.gemini.dto.GeminiWebSocketSubscriptionMessage;
import info.bitrich.xchangestream.gemini.dto.GeminiWebSocketTransaction;
import info.bitrich.xchangestream.service.netty.JsonNettyStreamingService;
import info.bitrich.xchangestream.service.netty.StreamingObjectMapperHelper;
import io.netty.util.internal.StringUtil;
import io.reactivex.Observable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.knowm.xchange.currency.CurrencyPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeminiStreamingService
extends JsonNettyStreamingService {
    private static final Logger LOG = LoggerFactory.getLogger(GeminiStreamingService.class);
    private static final String SHARE_CHANNEL_NAME = "ALL";
    private static final String SUBSCRIBE = "subscribe";
    private static final String UNSUBSCRIBE = "unsubscribe";
    private final Map<String, Observable<JsonNode>> subscriptions = new ConcurrentHashMap<String, Observable<JsonNode>>();
    private ProductSubscription product = null;

    public GeminiStreamingService(String baseUri) {
        super(baseUri, Integer.MAX_VALUE);
    }

    public ProductSubscription getProduct() {
        return this.product;
    }

    public Observable<GeminiWebSocketTransaction> getRawWebSocketTransactions(CurrencyPair currencyPair, boolean filterChannelName) {
        String channelName = currencyPair.base.toString() + currencyPair.counter.toString();
        ObjectMapper mapper = StreamingObjectMapperHelper.getObjectMapper();
        return this.subscribeChannel(channelName, new Object[0]).map(s -> (GeminiWebSocketTransaction)mapper.treeToValue((TreeNode)s, GeminiWebSocketTransaction.class)).filter(t -> channelName.equals(t.getSymbol())).filter(t -> !StringUtil.isNullOrEmpty((String)t.getType()));
    }

    public void subscribeMultipleCurrencyPairs(ProductSubscription ... products) {
        this.product = products[0];
    }

    public Observable<JsonNode> subscribeChannel(String channelName, Object ... args) {
        channelName = SHARE_CHANNEL_NAME;
        if (!this.channels.containsKey(channelName) && !this.subscriptions.containsKey(channelName)) {
            this.subscriptions.put(channelName, (Observable<JsonNode>)super.subscribeChannel(channelName, args));
        }
        return this.subscriptions.get(channelName);
    }

    public boolean processArrayMessageSeparately() {
        return false;
    }

    protected String getChannelNameFromMessage(JsonNode message) throws IOException {
        return SHARE_CHANNEL_NAME;
    }

    public String getSubscribeMessage(String channelName, Object ... args) throws IOException {
        return this.objectMapper.writeValueAsString((Object)new GeminiWebSocketSubscriptionMessage(SUBSCRIBE, this.product));
    }

    public String getUnsubscribeMessage(String channelName, Object ... args) throws IOException {
        return this.objectMapper.writeValueAsString((Object)new GeminiWebSocketSubscriptionMessage(UNSUBSCRIBE, this.product));
    }
}

