/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.gemini;

import com.google.common.base.MoreObjects;
import info.bitrich.xchangestream.core.StreamingMarketDataService;
import info.bitrich.xchangestream.gemini.GeminiStreamingService;
import io.reactivex.Observable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;

public class GeminiStreamingMarketDataService
implements StreamingMarketDataService {
    private static final String L2_UPDATES = "l2_updates";
    private final GeminiStreamingService service;
    private final Map<CurrencyPair, SortedMap<BigDecimal, BigDecimal>> bids = new ConcurrentHashMap<CurrencyPair, SortedMap<BigDecimal, BigDecimal>>();
    private final Map<CurrencyPair, SortedMap<BigDecimal, BigDecimal>> asks = new ConcurrentHashMap<CurrencyPair, SortedMap<BigDecimal, BigDecimal>>();

    public GeminiStreamingMarketDataService(GeminiStreamingService service) {
        this.service = service;
    }

    public Observable<OrderBook> getOrderBook(CurrencyPair currencyPair, Object ... args) {
        if (!this.service.getProduct().getOrderBook().stream().anyMatch(pair -> pair.toString().equals(currencyPair.toString()))) {
            throw new UnsupportedOperationException(String.format("The currency pair %s is not subscribed for orderbook", currencyPair));
        }
        int maxDepth = (Integer)MoreObjects.firstNonNull((Object)(args.length > 0 ? args[0] : null), (Object)1);
        return this.service.getRawWebSocketTransactions(currencyPair, false).filter(message -> L2_UPDATES.equals(message.getType())).map(message -> {
            this.bids.computeIfAbsent(currencyPair, k -> new TreeMap(Collections.reverseOrder()));
            this.asks.computeIfAbsent(currencyPair, k -> new TreeMap());
            return message.toOrderBook(this.bids.get(currencyPair), this.asks.get(currencyPair), maxDepth, currencyPair);
        });
    }

    public Observable<Ticker> getTicker(CurrencyPair currencyPair, Object ... args) {
        throw new NotYetImplementedForExchangeException("Not Yet Implemented!");
    }

    public Observable<Trade> getTrades(CurrencyPair currencyPair, Object ... args) {
        throw new NotYetImplementedForExchangeException("Not Yet Implemented!");
    }
}

