/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.gemini;

import info.bitrich.xchangestream.core.ProductSubscription;
import info.bitrich.xchangestream.core.StreamingExchange;
import info.bitrich.xchangestream.core.StreamingMarketDataService;
import info.bitrich.xchangestream.gemini.GeminiStreamingMarketDataService;
import info.bitrich.xchangestream.gemini.GeminiStreamingService;
import info.bitrich.xchangestream.service.netty.ConnectionStateModel;
import info.bitrich.xchangestream.service.netty.NettyStreamingService;
import io.reactivex.Completable;
import io.reactivex.Observable;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.gemini.v1.GeminiExchange;

public class GeminiStreamingExchange
extends GeminiExchange
implements StreamingExchange {
    private static final String API_V2_URI = "wss://api.gemini.com/v2/marketdata/";
    private GeminiStreamingService streamingService;
    private GeminiStreamingMarketDataService streamingMarketDataService;

    protected void initServices() {
        super.initServices();
    }

    public Completable connect(ProductSubscription ... args) {
        if (args == null || args.length == 0) {
            throw new UnsupportedOperationException("The ProductSubscription must be defined!");
        }
        ExchangeSpecification exchangeSpec = this.getExchangeSpecification();
        this.streamingService = new GeminiStreamingService(API_V2_URI);
        this.applyStreamingSpecification(exchangeSpec, (NettyStreamingService)this.streamingService);
        this.streamingMarketDataService = new GeminiStreamingMarketDataService(this.streamingService);
        this.streamingService.subscribeMultipleCurrencyPairs(args);
        return this.streamingService.connect();
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification spec = super.getDefaultExchangeSpecification();
        spec.setShouldLoadRemoteMetaData(false);
        return spec;
    }

    public Completable disconnect() {
        GeminiStreamingService service = this.streamingService;
        this.streamingService = null;
        this.streamingMarketDataService = null;
        return service.disconnect();
    }

    public StreamingMarketDataService getStreamingMarketDataService() {
        return this.streamingMarketDataService;
    }

    public Observable<ConnectionStateModel.State> connectionStateObservable() {
        return this.streamingService.subscribeConnectionState();
    }

    public boolean isAlive() {
        return this.streamingService != null && this.streamingService.isSocketOpen();
    }

    public void useCompressedMessages(boolean compressedMessages) {
        throw new NotYetImplementedForExchangeException();
    }
}

