/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.dydx;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import info.bitrich.xchangestream.core.ProductSubscription;
import info.bitrich.xchangestream.dydx.dto.dydxWebSocketSubscriptionMessage;
import info.bitrich.xchangestream.dydx.dto.dydxWebSocketTransaction;
import info.bitrich.xchangestream.dydx.dto.v1.dydxInitialOrderBookMessage;
import info.bitrich.xchangestream.dydx.dto.v1.dydxUpdateOrderBookMessage;
import info.bitrich.xchangestream.service.netty.JsonNettyStreamingService;
import info.bitrich.xchangestream.service.netty.StreamingObjectMapperHelper;
import io.reactivex.Observable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.knowm.xchange.currency.CurrencyPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class dydxStreamingService
extends JsonNettyStreamingService {
    private static final Logger LOG = LoggerFactory.getLogger(dydxStreamingService.class);
    private static final String SUBSCRIBE = "subscribe";
    private static final String UNSUBSCRIBE = "unsubscribe";
    private static final String CHANNEL = "channel";
    private static final String ID = "id";
    public static final String SUBSCRIBED = "subscribed";
    public static final String CHANNEL_DATA = "channel_data";
    public static final String V3_ORDERBOOK = "v3_orderbook";
    public static final String V3_TRADES = "v3_trades";
    public static final String V3_ACCOUNTS = "v3_accounts";
    public static final String V3_MARKETS = "v3_markets";
    public static final String V1_ORDERBOOK = "orderbook";
    public static final String V1_TRADES = "trades";
    public static final String V1_ACCOUNTS = "accounts";
    public static final String V1_MARKETS = "markets";
    public static final String ORDERBOOK = "orderbook";
    private final String apiUri;
    private ProductSubscription productSubscription;
    private final Map<String, Observable<JsonNode>> subscriptions = new ConcurrentHashMap<String, Observable<JsonNode>>();

    public dydxStreamingService(String apiUri) {
        super(apiUri, Integer.MAX_VALUE);
        this.apiUri = apiUri;
    }

    protected String getChannelNameFromMessage(JsonNode message) {
        return message.has(CHANNEL) && message.has(ID) ? String.format("%s-%s", message.get(CHANNEL).asText(), message.get(ID).asText()) : "";
    }

    public ProductSubscription getProduct() {
        return this.productSubscription;
    }

    public void subscribeMultipleCurrencyPairs(ProductSubscription ... products) {
        this.productSubscription = products[0];
    }

    public Observable<dydxWebSocketTransaction> getRawWebsocketTransactions(CurrencyPair currencyPair, String baseChannelName) {
        ObjectMapper mapper = StreamingObjectMapperHelper.getObjectMapper();
        String currencyPairChannelName = String.format("%s-%s", baseChannelName, currencyPair.toString().replace('/', '-'));
        return this.subscribeChannel(currencyPairChannelName, currencyPair).map(msg -> {
            switch (baseChannelName) {
                case "orderbook": 
                case "v3_orderbook": {
                    return this.handleOrderbookMessage(currencyPairChannelName, this.objectMapper, (JsonNode)msg);
                }
            }
            return (dydxWebSocketTransaction)mapper.treeToValue((TreeNode)msg, dydxWebSocketTransaction.class);
        }).filter(t -> currencyPair.equals((Object)new CurrencyPair(t.getId()))).filter(t -> baseChannelName.equals(t.getChannel()));
    }

    private dydxWebSocketTransaction handleOrderbookMessage(String orderBookChannel, ObjectMapper mapper, JsonNode msg) throws Exception {
        if (orderBookChannel.contains(V3_ORDERBOOK)) {
            switch (msg.get("type").asText()) {
                case "subscribed": {
                    return (dydxWebSocketTransaction)mapper.treeToValue((TreeNode)msg, info.bitrich.xchangestream.dydx.dto.v3.dydxInitialOrderBookMessage.class);
                }
                case "channel_data": {
                    return (dydxWebSocketTransaction)mapper.treeToValue((TreeNode)msg, info.bitrich.xchangestream.dydx.dto.v3.dydxUpdateOrderBookMessage.class);
                }
            }
        }
        if (orderBookChannel.contains("orderbook")) {
            switch (msg.get("type").asText()) {
                case "subscribed": {
                    return (dydxWebSocketTransaction)mapper.treeToValue((TreeNode)msg, dydxInitialOrderBookMessage.class);
                }
                case "channel_data": {
                    return (dydxWebSocketTransaction)mapper.treeToValue((TreeNode)msg, dydxUpdateOrderBookMessage.class);
                }
            }
        }
        return (dydxWebSocketTransaction)mapper.treeToValue((TreeNode)msg, dydxWebSocketTransaction.class);
    }

    public Observable<JsonNode> subscribeChannel(String channelName, Object ... args) {
        if (!this.channels.containsKey(channelName) && !this.subscriptions.containsKey(channelName)) {
            this.subscriptions.put(channelName, (Observable<JsonNode>)super.subscribeChannel(channelName, args));
        }
        return this.subscriptions.get(channelName);
    }

    public String getSubscribeMessage(String channelName, Object ... args) throws IOException {
        CurrencyPair currencyPair;
        CurrencyPair currencyPair2 = currencyPair = args.length > 0 && args[0] instanceof CurrencyPair ? (CurrencyPair)args[0] : null;
        if (channelName.contains("orderbook") && this.productSubscription != null && this.productSubscription.getOrderBook() != null) {
            return this.objectMapper.writeValueAsString((Object)new dydxWebSocketSubscriptionMessage(SUBSCRIBE, channelName.contains(V3_ORDERBOOK) ? V3_ORDERBOOK : "orderbook", currencyPair.toString().replace('/', '-')));
        }
        return null;
    }

    public String getUnsubscribeMessage(String channelName, Object ... args) throws IOException {
        return null;
    }
}

