/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.dydx;

import info.bitrich.xchangestream.core.ProductSubscription;
import info.bitrich.xchangestream.core.StreamingExchange;
import info.bitrich.xchangestream.core.StreamingMarketDataService;
import info.bitrich.xchangestream.dydx.dydxStreamingService;
import info.bitrich.xchangestream.dydx.service.v3.dydxStreamingMarketDataService;
import info.bitrich.xchangestream.service.netty.NettyStreamingService;
import io.reactivex.Completable;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.dydx.dydxExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class dydxStreamingExchange
extends dydxExchange
implements StreamingExchange {
    private static final Logger LOG = LoggerFactory.getLogger(dydxStreamingExchange.class);
    private static final String API_URI_V1 = "wss://api.dydx.exchange/v1/ws";
    private static final String API_URI_V3 = "wss://api.dydx.exchange/v3/ws";
    private static final String API_URI_ROPSTEN_V3 = "wss://api.stage.dydx.exchange/v3/ws";
    private dydxStreamingService streamingService;
    private StreamingMarketDataService streamingMarketDataService;

    public Completable connect(ProductSubscription ... args) {
        if (args == null || args.length == 0) {
            throw new UnsupportedOperationException("The ProductSubscription must be defined!");
        }
        ExchangeSpecification exchangeSpec = this.getExchangeSpecification();
        switch ((String)exchangeSpec.getExchangeSpecificParametersItem("version")) {
            case "v3": {
                this.streamingService = new dydxStreamingService(API_URI_V3);
                this.streamingMarketDataService = new dydxStreamingMarketDataService(this.streamingService);
                break;
            }
            case "v3_ropsten": {
                this.streamingService = new dydxStreamingService(API_URI_ROPSTEN_V3);
                this.streamingMarketDataService = new dydxStreamingMarketDataService(this.streamingService);
                break;
            }
            default: {
                this.streamingService = new dydxStreamingService(API_URI_V1);
                this.streamingMarketDataService = new info.bitrich.xchangestream.dydx.service.v1.dydxStreamingMarketDataService(this.streamingService);
            }
        }
        this.applyStreamingSpecification(this.getExchangeSpecification(), (NettyStreamingService)this.streamingService);
        this.streamingService.subscribeMultipleCurrencyPairs(args);
        return this.streamingService.connect();
    }

    public Completable disconnect() {
        dydxStreamingService service = this.streamingService;
        this.streamingService = null;
        this.streamingMarketDataService = null;
        return service.disconnect();
    }

    public StreamingMarketDataService getStreamingMarketDataService() {
        return this.streamingMarketDataService;
    }

    public boolean isAlive() {
        return this.streamingService != null && this.streamingService.isSocketOpen();
    }

    public void useCompressedMessages(boolean compressedMessages) {
        this.streamingService.useCompressedMessages(compressedMessages);
    }
}

