/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.dydx;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.instrument.Instrument;

public class dydxStreamingAdapters {
    public static final Map<Currency, Integer> amounts = new HashMap<Currency, Integer>(){
        {
            this.put(Currency.WETH, 18);
            this.put(Currency.DAI, 18);
            this.put(Currency.USDC, 6);
            this.put(Currency.USD, 6);
            this.put(Currency.PBTC, 8);
            this.put(Currency.PLINK, 6);
        }
    };

    public static List<LimitOrder> dydxOrderBookChanges(Order.OrderType orderType, CurrencyPair currencyPair, String[][] changes, SortedMap<BigDecimal, BigDecimal> sideEntries, int maxDepth, boolean isV1) {
        if (sideEntries == null) {
            return Collections.emptyList();
        }
        if (changes != null) {
            for (String[] level2 : changes) {
                BigDecimal volume;
                BigDecimal price;
                if (isV1) {
                    price = new BigDecimal(level2[level2.length - 2]).movePointRight(amounts.get(currencyPair.base) - amounts.get(currencyPair.counter));
                    volume = new BigDecimal(level2[level2.length - 1]).movePointLeft(amounts.get(currencyPair.base));
                } else {
                    price = new BigDecimal(level2[level2.length - 2]);
                    volume = new BigDecimal(level2[level2.length - 1]);
                }
                sideEntries.put(price, volume);
            }
        }
        Stream<Map.Entry> stream = sideEntries.entrySet().stream().filter(level -> ((BigDecimal)level.getValue()).compareTo(BigDecimal.ZERO) != 0);
        if (maxDepth != 0) {
            stream = stream.limit(maxDepth);
        }
        return stream.map(level -> new LimitOrder(orderType, (BigDecimal)level.getValue(), (Instrument)currencyPair, "0", null, (BigDecimal)level.getKey())).collect(Collectors.toList());
    }
}

