/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.dydx.dto.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import info.bitrich.xchangestream.dydx.dto.dydxWebSocketTransaction;
import info.bitrich.xchangestream.dydx.dydxStreamingAdapters;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.trade.LimitOrder;

public class dydxUpdateOrderBookMessage
extends dydxWebSocketTransaction {
    @JsonProperty(value="contents")
    private Contents contents;

    private String[][] buildChangeData(String side, Map<String, String> idMap) {
        return (String[][])Arrays.stream(this.contents.getUpdates()).filter(update -> side.equals(((Update)update).side)).map(update -> {
            switch (((Update)update).type) {
                case "NEW": {
                    idMap.put(((Update)update).id, ((Update)update).price);
                    return new String[]{((Update)update).price, ((Update)update).amount};
                }
                case "REMOVED": {
                    String removedPriceLevel = (String)idMap.get(((Update)update).id);
                    idMap.remove(((Update)update).id);
                    if (removedPriceLevel != null) {
                        return new String[]{removedPriceLevel, "0"};
                    }
                    return null;
                }
                case "UPDATED": {
                    String updatedPriceLevel = (String)idMap.get(((Update)update).id);
                    if (updatedPriceLevel != null) {
                        return new String[]{updatedPriceLevel, ((Update)update).amount};
                    }
                    return null;
                }
            }
            return null;
        }).filter(Objects::nonNull).toArray(x$0 -> new String[x$0][]);
    }

    public OrderBook toOrderBook(SortedMap<BigDecimal, BigDecimal> bids, SortedMap<BigDecimal, BigDecimal> asks, Map<String, String> bidIds, Map<String, String> askIds, int maxDepth, CurrencyPair currencyPair) {
        String[][] bidsData = this.buildChangeData("BUY", bidIds);
        String[][] asksData = this.buildChangeData("SELL", askIds);
        List<LimitOrder> dydxBids = dydxStreamingAdapters.dydxOrderBookChanges(Order.OrderType.BID, currencyPair, bidsData, bids, maxDepth, true);
        List<LimitOrder> dydxAsks = dydxStreamingAdapters.dydxOrderBookChanges(Order.OrderType.ASK, currencyPair, asksData, asks, maxDepth, true);
        return new OrderBook(null, dydxAsks, dydxBids, false);
    }

    public static class Contents {
        @JsonProperty(value="updates")
        private Update[] updates;

        public Update[] getUpdates() {
            return this.updates;
        }

        @JsonProperty(value="updates")
        public void setUpdates(Update[] updates) {
            this.updates = updates;
        }
    }

    public static class Update {
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="side")
        private String side;
        @JsonProperty(value="amount")
        private String amount;
        @JsonProperty(value="price")
        private String price;

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public String getSide() {
            return this.side;
        }

        public String getAmount() {
            return this.amount;
        }

        public String getPrice() {
            return this.price;
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="side")
        public void setSide(String side) {
            this.side = side;
        }

        @JsonProperty(value="amount")
        public void setAmount(String amount) {
            this.amount = amount;
        }

        @JsonProperty(value="price")
        public void setPrice(String price) {
            this.price = price;
        }
    }
}

