/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.dydx.dto.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import info.bitrich.xchangestream.dydx.dto.dydxWebSocketTransaction;
import info.bitrich.xchangestream.dydx.dydxStreamingAdapters;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.trade.LimitOrder;

public class dydxInitialOrderBookMessage
extends dydxWebSocketTransaction {
    @JsonProperty(value="contents")
    private Contents contents;

    public OrderBook toOrderBook(SortedMap<BigDecimal, BigDecimal> bids, SortedMap<BigDecimal, BigDecimal> asks, Map<String, String> bidIds, Map<String, String> askIds, int maxDepth, CurrencyPair currencyPair) {
        String[][] bidsData = null;
        String[][] asksData = null;
        if (this.contents.getBids() != null) {
            bidsData = (String[][])Arrays.stream(this.contents.getBids()).map(b -> {
                bidIds.put(((Order)b).id, ((Order)b).price);
                return new String[]{((Order)b).price, ((Order)b).amount};
            }).toArray(x$0 -> new String[x$0][]);
        }
        if (this.contents.getAsks() != null) {
            asksData = (String[][])Arrays.stream(this.contents.getAsks()).map(a -> {
                askIds.put(((Order)a).id, ((Order)a).price);
                return new String[]{((Order)a).price, ((Order)a).amount};
            }).toArray(x$0 -> new String[x$0][]);
        }
        List<LimitOrder> dydxBids = dydxStreamingAdapters.dydxOrderBookChanges(Order.OrderType.BID, currencyPair, bidsData, bids, maxDepth, true);
        List<LimitOrder> dydxAsks = dydxStreamingAdapters.dydxOrderBookChanges(Order.OrderType.ASK, currencyPair, asksData, asks, maxDepth, true);
        return new OrderBook(null, dydxBids, dydxAsks, false);
    }

    public static class Contents {
        @JsonProperty(value="offset")
        private String offset;
        @JsonProperty(value="bids")
        private Order[] bids;
        @JsonProperty(value="asks")
        private Order[] asks;

        public String getOffset() {
            return this.offset;
        }

        public Order[] getBids() {
            return this.bids;
        }

        public Order[] getAsks() {
            return this.asks;
        }

        @JsonProperty(value="offset")
        public void setOffset(String offset) {
            this.offset = offset;
        }

        @JsonProperty(value="bids")
        public void setBids(Order[] bids) {
            this.bids = bids;
        }

        @JsonProperty(value="asks")
        public void setAsks(Order[] asks) {
            this.asks = asks;
        }
    }

    public static class Order {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="uuid")
        private String uuid;
        @JsonProperty(value="price")
        private String price;
        @JsonProperty(value="amount")
        private String amount;

        public String getId() {
            return this.id;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getPrice() {
            return this.price;
        }

        public String getAmount() {
            return this.amount;
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="uuid")
        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        @JsonProperty(value="price")
        public void setPrice(String price) {
            this.price = price;
        }

        @JsonProperty(value="amount")
        public void setAmount(String amount) {
            this.amount = amount;
        }
    }
}

