/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.util;

import info.bitrich.xchangestream.util.LocalExchangeConfig;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropsLoader {
    private static final Logger LOG = LoggerFactory.getLogger(PropsLoader.class);

    public static LocalExchangeConfig loadKeys(String fileName, String originName, String prefix) throws IOException {
        LocalExchangeConfig localExchangeConfig;
        String apiKeyName = prefix + ".api.key";
        String secretKeyName = prefix + ".secret.key";
        String apiKey = System.getProperty(apiKeyName);
        String secretKey = System.getProperty(secretKeyName);
        if (apiKey != null && secretKey != null) {
            return new LocalExchangeConfig(apiKey, secretKey);
        }
        LOG.info("Not found keys in system props, loading from a file {}...", (Object)fileName);
        FileInputStream input = new FileInputStream(fileName);
        try {
            Properties properties = new Properties();
            properties.load(input);
            localExchangeConfig = new LocalExchangeConfig(properties.getProperty(apiKeyName), properties.getProperty(secretKeyName));
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                LOG.error("Please create {} file from {}", (Object)fileName, (Object)originName);
                throw e;
            }
        }
        input.close();
        return localExchangeConfig;
    }

    public static String proxyExecLine() {
        return System.getProperty("proxy.exec.line");
    }
}

