/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.core;

import info.bitrich.xchangestream.core.StreamingExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.utils.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum StreamingExchangeFactory {
    INSTANCE;

    private final Logger LOG = LoggerFactory.getLogger(ExchangeFactory.class);

    public StreamingExchange createExchangeWithoutSpecification(String exchangeClassName) {
        Assert.notNull((Object)exchangeClassName, (String)"exchangeClassName cannot be null");
        this.LOG.debug("Creating default exchange from class name");
        Class<? extends StreamingExchange> exchangeClass = StreamingExchangeFactory.exchangeClassForName(exchangeClassName);
        return this.createExchangeWithoutSpecification(exchangeClass);
    }

    private static Class<? extends StreamingExchange> exchangeClassForName(String exchangeClassName) {
        try {
            Class<?> exchangeProviderClass = Class.forName(exchangeClassName);
            if (StreamingExchange.class.isAssignableFrom(exchangeProviderClass)) {
                return exchangeProviderClass;
            }
            throw new ExchangeException("Class '" + exchangeClassName + "' does not implement Exchange");
        }
        catch (ReflectiveOperationException e) {
            throw new ExchangeException("Problem creating Exchange ", (Throwable)e);
        }
    }

    public StreamingExchange createExchangeWithoutSpecification(Class<? extends StreamingExchange> exchangeClass) {
        Assert.notNull(exchangeClass, (String)"exchangeClass cannot be null");
        this.LOG.debug("Creating default exchange from class name");
        try {
            return exchangeClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ExchangeException("Problem creating Exchange for class: " + exchangeClass.getName(), (Throwable)e);
        }
    }

    public StreamingExchange createExchange(String exchangeClassName) {
        Assert.notNull((Object)exchangeClassName, (String)"exchangeClassName cannot be null");
        this.LOG.debug("Creating default exchange from class name");
        StreamingExchange exchange = this.createExchangeWithoutSpecification(exchangeClassName);
        exchange.applySpecification(exchange.getDefaultExchangeSpecification());
        return exchange;
    }

    public StreamingExchange createExchange(Class<? extends StreamingExchange> exchangeClass) {
        Assert.notNull(exchangeClass, (String)"exchangeClass cannot be null");
        this.LOG.debug("Creating default exchange from class name");
        StreamingExchange exchange = this.createExchangeWithoutSpecification(exchangeClass);
        exchange.applySpecification(exchange.getDefaultExchangeSpecification());
        return exchange;
    }

    public StreamingExchange createExchange(ExchangeSpecification exchangeSpecification) {
        Assert.notNull((Object)exchangeSpecification, (String)"exchangeSpecfication cannot be null");
        this.LOG.debug("Creating exchange from specification");
        Class exchangeProviderClass = exchangeSpecification.getExchangeClass();
        try {
            if (Exchange.class.isAssignableFrom(exchangeProviderClass)) {
                StreamingExchange exchange = (StreamingExchange)exchangeProviderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                exchange.applySpecification(exchangeSpecification);
                return exchange;
            }
            throw new ExchangeException("Class '" + exchangeProviderClass.getName() + "' does not implement Exchange");
        }
        catch (ReflectiveOperationException e) {
            throw new ExchangeException("Problem starting exchange provider ", (Throwable)e);
        }
    }
}

