/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.instrument.Instrument;

public class ProductSubscription {
    private final List<Instrument> orderBook;
    private final List<Instrument> trades;
    private final List<Instrument> ticker;
    private final List<Instrument> userTrades;
    private final List<Instrument> orders;
    private final List<Instrument> fundingRates;
    private final List<Currency> balances;

    private ProductSubscription(ProductSubscriptionBuilder builder) {
        this.orderBook = this.asList(builder.orderBook);
        this.trades = this.asList(builder.trades);
        this.ticker = this.asList(builder.ticker);
        this.orders = this.asList(builder.orders);
        this.fundingRates = this.asList(builder.fundingRates);
        this.userTrades = this.asList(builder.userTrades);
        this.balances = this.asList(builder.balances);
    }

    private <T> List<T> asList(Iterable<T> collection) {
        ArrayList result = new ArrayList();
        collection.forEach(result::add);
        return Collections.unmodifiableList(result);
    }

    public List<Instrument> getOrderBook() {
        return this.orderBook;
    }

    public List<Instrument> getTrades() {
        return this.trades;
    }

    public List<Instrument> getTicker() {
        return this.ticker;
    }

    public List<Instrument> getOrders() {
        return this.orders;
    }

    public List<Instrument> getFundingRates() {
        return this.fundingRates;
    }

    public List<Instrument> getUserTrades() {
        return this.userTrades;
    }

    public List<Currency> getBalances() {
        return this.balances;
    }

    public boolean isEmpty() {
        return !this.hasAuthenticated() && !this.hasUnauthenticated();
    }

    public boolean hasAuthenticated() {
        return !this.orders.isEmpty() || !this.userTrades.isEmpty() || !this.balances.isEmpty();
    }

    public boolean hasUnauthenticated() {
        return !this.ticker.isEmpty() || !this.trades.isEmpty() || !this.orderBook.isEmpty() || !this.fundingRates.isEmpty();
    }

    public static ProductSubscriptionBuilder create() {
        return new ProductSubscriptionBuilder();
    }

    public static class ProductSubscriptionBuilder {
        private final Set<Instrument> orderBook = new HashSet<Instrument>();
        private final Set<Instrument> trades = new HashSet<Instrument>();
        private final Set<Instrument> ticker = new HashSet<Instrument>();
        private final Set<Instrument> userTrades;
        private final Set<Instrument> orders = new HashSet<Instrument>();
        private final Set<Instrument> fundingRates = new HashSet<Instrument>();
        private final Set<Currency> balances;

        private ProductSubscriptionBuilder() {
            this.userTrades = new HashSet<Instrument>();
            this.balances = new HashSet<Currency>();
        }

        public ProductSubscriptionBuilder addOrderbook(Instrument pair) {
            this.orderBook.add(pair);
            return this;
        }

        public ProductSubscriptionBuilder addTrades(Instrument pair) {
            this.trades.add(pair);
            return this;
        }

        public ProductSubscriptionBuilder addTicker(Instrument pair) {
            this.ticker.add(pair);
            return this;
        }

        public ProductSubscriptionBuilder addOrders(Instrument pair) {
            this.orders.add(pair);
            return this;
        }

        public ProductSubscriptionBuilder addFundingRates(Instrument pair) {
            this.fundingRates.add(pair);
            return this;
        }

        public ProductSubscriptionBuilder addUserTrades(Instrument pair) {
            this.userTrades.add(pair);
            return this;
        }

        public ProductSubscriptionBuilder addBalances(Currency pair) {
            this.balances.add(pair);
            return this;
        }

        public ProductSubscriptionBuilder addAll(Instrument pair) {
            this.orderBook.add(pair);
            this.trades.add(pair);
            this.ticker.add(pair);
            this.orders.add(pair);
            this.fundingRates.add(pair);
            this.userTrades.add(pair);
            this.balances.add(pair.getBase());
            this.balances.add(pair.getCounter());
            return this;
        }

        public ProductSubscription build() {
            return new ProductSubscription(this);
        }
    }
}

