/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.coincheck.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.math.BigDecimal;
import org.knowm.xchange.coincheck.dto.marketdata.CoincheckPair;

@JsonFormat(shape=JsonFormat.Shape.ARRAY)
@JsonPropertyOrder(value={"id", "pair", "price", "amount", "orderType"})
@JsonDeserialize(builder=CoincheckStreamingTradeBuilder.class)
public final class CoincheckStreamingTrade {
    private final String id;
    private final CoincheckPair pair;
    private final BigDecimal price;
    private final BigDecimal amount;
    private final String orderType;

    CoincheckStreamingTrade(String id, CoincheckPair pair, BigDecimal price, BigDecimal amount, String orderType) {
        this.id = id;
        this.pair = pair;
        this.price = price;
        this.amount = amount;
        this.orderType = orderType;
    }

    public static CoincheckStreamingTradeBuilder builder() {
        return new CoincheckStreamingTradeBuilder();
    }

    public CoincheckStreamingTradeBuilder toBuilder() {
        return new CoincheckStreamingTradeBuilder().id(this.id).pair(this.pair).price(this.price).amount(this.amount).orderType(this.orderType);
    }

    public String getId() {
        return this.id;
    }

    public CoincheckPair getPair() {
        return this.pair;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoincheckStreamingTrade)) {
            return false;
        }
        CoincheckStreamingTrade other = (CoincheckStreamingTrade)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        CoincheckPair this$pair = this.getPair();
        CoincheckPair other$pair = other.getPair();
        if (this$pair == null ? other$pair != null : !this$pair.equals(other$pair)) {
            return false;
        }
        BigDecimal this$price = this.getPrice();
        BigDecimal other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$orderType = this.getOrderType();
        String other$orderType = other.getOrderType();
        return !(this$orderType == null ? other$orderType != null : !this$orderType.equals(other$orderType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        CoincheckPair $pair = this.getPair();
        result = result * 59 + ($pair == null ? 43 : $pair.hashCode());
        BigDecimal $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $orderType = this.getOrderType();
        result = result * 59 + ($orderType == null ? 43 : $orderType.hashCode());
        return result;
    }

    public String toString() {
        return "CoincheckStreamingTrade(id=" + this.getId() + ", pair=" + this.getPair() + ", price=" + this.getPrice() + ", amount=" + this.getAmount() + ", orderType=" + this.getOrderType() + ")";
    }

    @JsonFormat(shape=JsonFormat.Shape.ARRAY)
    @JsonPropertyOrder(value={"id", "pair", "price", "amount", "orderType"})
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class CoincheckStreamingTradeBuilder {
        private String id;
        private CoincheckPair pair;
        private BigDecimal price;
        private BigDecimal amount;
        private String orderType;

        CoincheckStreamingTradeBuilder() {
        }

        public CoincheckStreamingTradeBuilder id(String id) {
            this.id = id;
            return this;
        }

        public CoincheckStreamingTradeBuilder pair(CoincheckPair pair) {
            this.pair = pair;
            return this;
        }

        public CoincheckStreamingTradeBuilder price(BigDecimal price) {
            this.price = price;
            return this;
        }

        public CoincheckStreamingTradeBuilder amount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public CoincheckStreamingTradeBuilder orderType(String orderType) {
            this.orderType = orderType;
            return this;
        }

        public CoincheckStreamingTrade build() {
            return new CoincheckStreamingTrade(this.id, this.pair, this.price, this.amount, this.orderType);
        }

        public String toString() {
            return "CoincheckStreamingTrade.CoincheckStreamingTradeBuilder(id=" + this.id + ", pair=" + this.pair + ", price=" + this.price + ", amount=" + this.amount + ", orderType=" + this.orderType + ")";
        }
    }
}

