/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.coincheck;

import com.fasterxml.jackson.databind.JsonNode;
import info.bitrich.xchangestream.coincheck.CoincheckStreamingAdapter;
import info.bitrich.xchangestream.coincheck.dto.CoincheckSubscribeMessage;
import info.bitrich.xchangestream.service.netty.JsonNettyStreamingService;
import info.bitrich.xchangestream.service.netty.WebSocketClientCompressionAllowClientNoContextAndServerNoContextHandler;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandler;
import java.io.IOException;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoincheckStreamingService
extends JsonNettyStreamingService {
    private static final Logger log = LoggerFactory.getLogger(CoincheckStreamingService.class);

    public CoincheckStreamingService(String baseUri) {
        super(baseUri, Integer.MAX_VALUE);
    }

    public CoincheckStreamingService(String baseUri, int maxFramePayloadLength, Duration connectionTimeout, Duration retryDuration, int idleTimeoutSeconds) {
        super(baseUri, maxFramePayloadLength, connectionTimeout, retryDuration, idleTimeoutSeconds);
    }

    protected void handleMessage(JsonNode message) {
        super.handleMessage((Object)message);
    }

    public String getSubscribeMessage(String channelName, Object ... args) throws IOException {
        CoincheckSubscribeMessage msg = new CoincheckSubscribeMessage("subscribe", channelName);
        return this.objectMapper.writeValueAsString((Object)msg);
    }

    public String getUnsubscribeMessage(String channelName, Object ... args) throws IOException {
        return null;
    }

    protected WebSocketClientExtensionHandler getWebSocketClientExtensionHandler() {
        return WebSocketClientCompressionAllowClientNoContextAndServerNoContextHandler.INSTANCE;
    }

    public boolean processArrayMessageSeparately() {
        return false;
    }

    protected String getChannelNameFromMessage(JsonNode message) throws IOException {
        return CoincheckStreamingAdapter.getChannelNameFromMessage(message);
    }
}

