/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.coincheck;

import com.fasterxml.jackson.databind.ObjectMapper;
import info.bitrich.xchangestream.coincheck.CoincheckStreamingAdapter;
import info.bitrich.xchangestream.coincheck.CoincheckStreamingService;
import info.bitrich.xchangestream.coincheck.dto.CoincheckSubscriptionNames;
import info.bitrich.xchangestream.core.StreamingMarketDataService;
import info.bitrich.xchangestream.service.netty.StreamingObjectMapperHelper;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.schedulers.Schedulers;
import java.util.stream.Stream;
import lombok.NonNull;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.coincheck.CoincheckExchange;
import org.knowm.xchange.coincheck.dto.marketdata.CoincheckPair;
import org.knowm.xchange.coincheck.service.CoincheckMarketDataService;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.OrderBookUpdate;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.instrument.Instrument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoincheckStreamingMarketDataService
implements StreamingMarketDataService {
    private static final Logger log = LoggerFactory.getLogger(CoincheckStreamingMarketDataService.class);
    private final CoincheckStreamingService service;
    private final Runnable onApiCall;
    private final CoincheckMarketDataService marketDataService = (CoincheckMarketDataService)((CoincheckExchange)ExchangeFactory.INSTANCE.createExchange(CoincheckExchange.class)).getMarketDataService();
    private final ObjectMapper mapper = StreamingObjectMapperHelper.getObjectMapper();

    public Observable<OrderBook> getOrderBook(CurrencyPair currencyPair, Object ... args) {
        String channelName = this.getChannelName(CoincheckSubscriptionNames.ORDERBOOK, currencyPair);
        return Single.fromCallable(() -> this.marketDataService.getOrderBook(currencyPair, new Object[0])).subscribeOn(Schedulers.io()).observeOn(Schedulers.computation()).flatMapObservable(orderBook -> this.service.subscribeChannel(channelName, new Object[0]).map(json -> {
            Stream<OrderBookUpdate> updates = CoincheckStreamingAdapter.parseOrderBookUpdates(json);
            updates.forEach(arg_0 -> ((OrderBook)orderBook).update(arg_0));
            return new OrderBook(null, orderBook.getAsks(), orderBook.getBids());
        }));
    }

    public Observable<Ticker> getTicker(CurrencyPair currencyPair, Object ... args) {
        return this.getOrderBook(currencyPair, args).map(book -> {
            LimitOrder lowestAsk = (LimitOrder)book.getAsks().get(0);
            LimitOrder highestBid = (LimitOrder)book.getBids().get(0);
            return new Ticker.Builder().instrument((Instrument)currencyPair).timestamp(book.getTimeStamp()).ask(lowestAsk == null ? null : lowestAsk.getLimitPrice()).bid(highestBid == null ? null : highestBid.getLimitPrice()).build();
        });
    }

    public Observable<Trade> getTrades(CurrencyPair currencyPair, Object ... args) {
        String channelName = this.getChannelName(CoincheckSubscriptionNames.TRADES, currencyPair);
        return this.service.subscribeChannel(channelName, new Object[0]).map(json -> CoincheckStreamingAdapter.parseTrade(json));
    }

    private String getChannelName(@NonNull CoincheckSubscriptionNames name, @NonNull CurrencyPair currencyPair) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (currencyPair == null) {
            throw new NullPointerException("currencyPair is marked non-null but is null");
        }
        return CoincheckPair.pairToString((CoincheckPair)new CoincheckPair(currencyPair)) + "-" + name.getName();
    }

    public CoincheckStreamingMarketDataService(CoincheckStreamingService service, Runnable onApiCall) {
        this.service = service;
        this.onApiCall = onApiCall;
    }
}

