/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.coincheck;

import info.bitrich.xchangestream.coincheck.CoincheckStreamingMarketDataService;
import info.bitrich.xchangestream.coincheck.CoincheckStreamingService;
import info.bitrich.xchangestream.core.ProductSubscription;
import info.bitrich.xchangestream.core.StreamingExchange;
import info.bitrich.xchangestream.service.netty.ConnectionStateModel;
import info.bitrich.xchangestream.service.netty.NettyStreamingService;
import info.bitrich.xchangestream.util.Events;
import io.reactivex.Completable;
import io.reactivex.Observable;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.coincheck.CoincheckExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoincheckStreamingExchange
extends CoincheckExchange
implements StreamingExchange {
    private static final Logger log = LoggerFactory.getLogger(CoincheckStreamingExchange.class);
    private static final String WS_API_URI = "wss://ws-api.coincheck.com/";
    private CoincheckStreamingService streamingService;
    private CoincheckStreamingMarketDataService streamingMarketDataService;
    private Runnable onApiCall;

    protected void initServices() {
        super.initServices();
        this.streamingService = new CoincheckStreamingService(WS_API_URI);
        this.applyStreamingSpecification(this.getExchangeSpecification(), (NettyStreamingService)this.streamingService);
        this.streamingMarketDataService = new CoincheckStreamingMarketDataService(this.streamingService, this.onApiCall);
        this.onApiCall = Events.onApiCall((ExchangeSpecification)this.exchangeSpecification);
    }

    public Completable connect(ProductSubscription ... args) {
        return this.streamingService.connect();
    }

    public Completable disconnect() {
        Completable completable = this.streamingService.disconnect();
        this.streamingService = null;
        this.streamingMarketDataService = null;
        return completable;
    }

    public boolean isAlive() {
        return this.streamingService != null && this.streamingService.isSocketOpen();
    }

    public Observable<Throwable> reconnectFailure() {
        return this.streamingService.subscribeReconnectFailure();
    }

    public Observable<Object> connectionSuccess() {
        return this.streamingService.subscribeConnectionSuccess();
    }

    public Observable<ConnectionStateModel.State> connectionStateObservable() {
        return this.streamingService.subscribeConnectionState();
    }

    public CoincheckStreamingMarketDataService getStreamingMarketDataService() {
        return this.streamingMarketDataService;
    }

    public void useCompressedMessages(boolean compressedMessages) {
        this.streamingService.useCompressedMessages(compressedMessages);
    }
}

