/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.coinbasepro.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import info.bitrich.xchangestream.coinbasepro.CoinbaseProStreamingAdapters;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.stream.Stream;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProProductStats;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProProductTicker;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProTrade;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProFill;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.instrument.Instrument;

public class CoinbaseProWebSocketTransaction {
    private final String type;
    private final String orderId;
    private final String orderType;
    private final BigDecimal size;
    private final BigDecimal remainingSize;
    private final BigDecimal price;
    private final BigDecimal bestBid;
    private final BigDecimal bestAsk;
    private final BigDecimal lastSize;
    private final BigDecimal volume24h;
    private final BigDecimal open24h;
    private final BigDecimal low24h;
    private final BigDecimal high24h;
    private final String side;
    private final String[][] bids;
    private final String[][] asks;
    private final String[][] changes;
    private final String clientOid;
    private final String productId;
    private final long sequence;
    private final String time;
    private final String reason;
    private final long tradeId;
    private final String makerOrderId;
    private final String takerOrderId;
    private final String takerUserId;
    private final String userId;
    private final String takerProfileId;
    private final String profileId;

    public CoinbaseProWebSocketTransaction(@JsonProperty(value="type") String type, @JsonProperty(value="order_id") String orderId, @JsonProperty(value="order_type") String orderType, @JsonProperty(value="size") BigDecimal size, @JsonProperty(value="remaining_size") BigDecimal remainingSize, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="best_bid") BigDecimal bestBid, @JsonProperty(value="best_ask") BigDecimal bestAsk, @JsonProperty(value="last_size") BigDecimal lastSize, @JsonProperty(value="volume_24h") BigDecimal volume24h, @JsonProperty(value="open_24h") BigDecimal open24h, @JsonProperty(value="low_24h") BigDecimal low24h, @JsonProperty(value="high_24h") BigDecimal high24h, @JsonProperty(value="side") String side, @JsonProperty(value="bids") String[][] bids, @JsonProperty(value="asks") String[][] asks, @JsonProperty(value="changes") String[][] changes, @JsonProperty(value="client_oid") String clientOid, @JsonProperty(value="product_id") String productId, @JsonProperty(value="sequence") long sequence, @JsonProperty(value="time") String time, @JsonProperty(value="reason") String reason, @JsonProperty(value="trade_id") long tradeId, @JsonProperty(value="maker_order_id") String makerOrderId, @JsonProperty(value="taker_order_id") String takerOrderId, @JsonProperty(value="taker_user_id") String takerUserId, @JsonProperty(value="user_id") String userId, @JsonProperty(value="taker_profile_id") String takerProfileId, @JsonProperty(value="profile_id") String profileId) {
        this.remainingSize = remainingSize;
        this.reason = reason;
        this.tradeId = tradeId;
        this.makerOrderId = makerOrderId;
        this.takerOrderId = takerOrderId;
        this.type = type;
        this.orderId = orderId;
        this.orderType = orderType;
        this.size = size;
        this.price = price;
        this.bestBid = bestBid;
        this.bestAsk = bestAsk;
        this.lastSize = lastSize;
        this.volume24h = volume24h;
        this.high24h = high24h;
        this.low24h = low24h;
        this.open24h = open24h;
        this.side = side;
        this.bids = bids;
        this.asks = asks;
        this.changes = changes;
        this.clientOid = clientOid;
        this.productId = productId;
        this.sequence = sequence;
        this.time = time;
        this.takerUserId = takerUserId;
        this.userId = userId;
        this.takerProfileId = takerProfileId;
        this.profileId = profileId;
    }

    private Stream<LimitOrder> coinbaseProOrderBookChanges(String side, Order.OrderType orderType, CurrencyPair currencyPair, String[][] changes, SortedMap<BigDecimal, LimitOrder> sideEntries, int maxDepth) {
        if (changes.length == 0) {
            return Stream.empty();
        }
        if (sideEntries == null) {
            return Stream.empty();
        }
        for (String[] level : changes) {
            if (level.length == 3 && !level[0].equals(side)) continue;
            BigDecimal price = new BigDecimal(level[level.length - 2]);
            BigDecimal volume = new BigDecimal(level[level.length - 1]);
            if (volume.compareTo(BigDecimal.ZERO) == 0) {
                sideEntries.remove(price);
                continue;
            }
            LimitOrder order = new LimitOrder(orderType, volume, (Instrument)currencyPair, "0", null, price);
            sideEntries.put(price, order);
        }
        Stream<LimitOrder> stream = sideEntries.values().stream();
        if (maxDepth != 0) {
            stream = stream.limit(maxDepth);
        }
        return stream;
    }

    public OrderBook toOrderBook(SortedMap<BigDecimal, LimitOrder> bids, SortedMap<BigDecimal, LimitOrder> asks, int maxDepth, CurrencyPair currencyPair) {
        Stream<LimitOrder> gdaxOrderBookBids = this.coinbaseProOrderBookChanges("buy", Order.OrderType.BID, currencyPair, this.changes != null ? this.changes : this.bids, bids, maxDepth);
        Stream<LimitOrder> gdaxOrderBookAsks = this.coinbaseProOrderBookChanges("sell", Order.OrderType.ASK, currencyPair, this.changes != null ? this.changes : this.asks, asks, maxDepth);
        return new OrderBook(this.time == null ? null : CoinbaseProStreamingAdapters.parseDate(this.time), gdaxOrderBookAsks, gdaxOrderBookBids, false);
    }

    public CoinbaseProProductTicker toCoinbaseProProductTicker() {
        String tickerTime = this.time;
        if (tickerTime == null) {
            SimpleDateFormat dateFormatGmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            dateFormatGmt.setTimeZone(TimeZone.getTimeZone("UTC"));
            tickerTime = dateFormatGmt.format(new Date());
        }
        return new CoinbaseProProductTicker(String.valueOf(this.tradeId), this.price, this.lastSize, this.bestBid, this.bestAsk, this.volume24h, tickerTime);
    }

    public CoinbaseProProductStats toCoinbaseProProductStats() {
        return new CoinbaseProProductStats(this.open24h, this.high24h, this.low24h, this.volume24h);
    }

    public CoinbaseProTrade toCoinbaseProTrade() {
        return new CoinbaseProTrade(this.time, this.tradeId, this.price, this.size, this.side, this.makerOrderId, this.takerOrderId);
    }

    public CoinbaseProFill toCoinbaseProFill() {
        boolean taker = this.userId != null && this.takerUserId != null && this.userId.equals(this.takerUserId);
        String useSide = this.side;
        if (taker && this.side != null) {
            useSide = "buy".equals(this.side) ? "sell" : "buy";
        }
        return new CoinbaseProFill(String.valueOf(this.tradeId), this.productId, this.price, this.size, taker ? this.takerOrderId : this.makerOrderId, this.time, null, null, true, useSide);
    }

    public String getType() {
        return this.type;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public BigDecimal getSize() {
        return this.size;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getBestBid() {
        return this.bestBid;
    }

    public BigDecimal getBestAsk() {
        return this.bestAsk;
    }

    public BigDecimal getLastSize() {
        return this.lastSize;
    }

    public BigDecimal getVolume24h() {
        return this.volume24h;
    }

    public BigDecimal getOpen24h() {
        return this.open24h;
    }

    public BigDecimal getLow24h() {
        return this.low24h;
    }

    public BigDecimal getHigh24h() {
        return this.high24h;
    }

    public String getSide() {
        return this.side;
    }

    public String getClientOid() {
        return this.clientOid;
    }

    public String getProductId() {
        return this.productId;
    }

    public Long getSequence() {
        return this.sequence;
    }

    public String getTime() {
        return this.time;
    }

    public BigDecimal getRemainingSize() {
        return this.remainingSize;
    }

    public String getReason() {
        return this.reason;
    }

    public long getTradeId() {
        return this.tradeId;
    }

    public String getMakerOrderId() {
        return this.makerOrderId;
    }

    @Deprecated
    public String getTakenOrderId() {
        return this.takerOrderId;
    }

    public String getTakerOrderId() {
        return this.takerOrderId;
    }

    public String getTakerUserId() {
        return this.takerUserId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getTakerProfileId() {
        return this.takerProfileId;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CoinbaseProWebSocketTransaction{");
        sb.append("type='").append(this.type).append('\'');
        sb.append(", orderId='").append(this.orderId).append('\'');
        sb.append(", orderType='").append(this.orderType).append('\'');
        sb.append(", size=").append(this.size);
        sb.append(", remainingSize=").append(this.remainingSize);
        sb.append(", price=").append(this.price);
        sb.append(", bestBid=").append(this.bestBid);
        sb.append(", bestAsk=").append(this.bestAsk);
        sb.append(", lastSize=").append(this.lastSize);
        sb.append(", volume24h=").append(this.volume24h);
        sb.append(", open24h=").append(this.open24h);
        sb.append(", low24h=").append(this.low24h);
        sb.append(", high24h=").append(this.high24h);
        sb.append(", side='").append(this.side).append('\'');
        sb.append(", bids=").append(this.bids);
        sb.append(", asks=").append(this.asks);
        sb.append(", changes=").append(this.asks);
        sb.append(", clientOid='").append(this.clientOid).append('\'');
        sb.append(", productId='").append(this.productId).append('\'');
        sb.append(", sequence=").append(this.sequence);
        sb.append(", time='").append(this.time).append('\'');
        sb.append(", reason='").append(this.reason).append('\'');
        sb.append(", trade_id='").append(this.tradeId).append('\'');
        if (this.userId != null) {
            sb.append(", userId='").append(this.userId).append('\'');
        }
        if (this.profileId != null) {
            sb.append(", profileId='").append(this.profileId).append('\'');
        }
        if (this.takerUserId != null) {
            sb.append(", takerUserId='").append(this.takerUserId).append('\'');
        }
        if (this.takerProfileId != null) {
            sb.append(", takerProfileId='").append(this.takerProfileId).append('\'');
        }
        sb.append('}');
        return sb.toString();
    }
}

