/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.coinbasepro;

import info.bitrich.xchangestream.coinbasepro.CoinbaseProStreamingMarketDataService;
import info.bitrich.xchangestream.coinbasepro.CoinbaseProStreamingService;
import info.bitrich.xchangestream.coinbasepro.CoinbaseProStreamingTradeService;
import info.bitrich.xchangestream.coinbasepro.dto.CoinbaseProOrderBookMode;
import info.bitrich.xchangestream.core.ProductSubscription;
import info.bitrich.xchangestream.core.StreamingAccountService;
import info.bitrich.xchangestream.core.StreamingExchange;
import info.bitrich.xchangestream.service.netty.ConnectionStateModel;
import info.bitrich.xchangestream.service.netty.NettyStreamingService;
import info.bitrich.xchangestream.service.netty.WebSocketClientHandler;
import io.reactivex.Completable;
import io.reactivex.Observable;
import java.util.Arrays;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.coinbasepro.CoinbaseProExchange;
import org.knowm.xchange.coinbasepro.dto.account.CoinbaseProWebsocketAuthData;
import org.knowm.xchange.coinbasepro.service.CoinbaseProAccountServiceRaw;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;

public class CoinbaseProStreamingExchange
extends CoinbaseProExchange
implements StreamingExchange {
    private static final String API_URI = "wss://ws-feed.pro.coinbase.com";
    private static final String SANDBOX_API_URI = "wss://ws-feed-public.sandbox.pro.coinbase.com";
    private static final String PRIME_API_URI = "wss://ws-feed.exchange.coinbase.com";
    private static final String PRIME_SANDBOX_API_URI = "wss://ws-feed-public.sandbox.exchange.coinbase.com";
    private static final String PARAM_ORDER_BOOK_MODE = "OrderBook_Mode";
    private CoinbaseProStreamingService streamingService;
    private CoinbaseProStreamingMarketDataService streamingMarketDataService;
    private CoinbaseProStreamingTradeService streamingTradeService;

    protected void initServices() {
        super.initServices();
    }

    public Completable connect(ProductSubscription ... args) {
        if (args == null || args.length == 0) {
            throw new UnsupportedOperationException("The ProductSubscription must be defined!");
        }
        ExchangeSpecification exchangeSpec = this.getExchangeSpecification();
        String apiUri = this.getApiUri();
        CoinbaseProOrderBookMode orderBookMode = CoinbaseProOrderBookMode.Default;
        Object orderBookModeParameter = this.exchangeSpecification.getExchangeSpecificParametersItem(PARAM_ORDER_BOOK_MODE);
        if (orderBookModeParameter != null) {
            try {
                orderBookMode = CoinbaseProOrderBookMode.valueOf(orderBookModeParameter.toString());
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Order book mode '" + orderBookModeParameter + "' is not supported, use one of " + Arrays.toString((Object[])CoinbaseProOrderBookMode.values()));
            }
        }
        if (Boolean.TRUE.equals(this.exchangeSpecification.getExchangeSpecificParametersItem("L3_Orderbook"))) {
            if (orderBookMode != CoinbaseProOrderBookMode.Default) {
                throw new RuntimeException("Parameter L3_Orderbook cannot be specified along with OrderBook_Mode");
            }
            orderBookMode = CoinbaseProOrderBookMode.Full;
        }
        this.streamingService = new CoinbaseProStreamingService(apiUri, () -> this.authData(exchangeSpec), orderBookMode);
        this.applyStreamingSpecification(this.exchangeSpecification, (NettyStreamingService)this.streamingService);
        this.streamingMarketDataService = new CoinbaseProStreamingMarketDataService(this.streamingService);
        this.streamingTradeService = new CoinbaseProStreamingTradeService(this.streamingService);
        this.streamingService.subscribeMultipleCurrencyPairs(args);
        return this.streamingService.connect();
    }

    public String getApiUri() {
        ExchangeSpecification exchangeSpec = this.getExchangeSpecification();
        boolean useSandbox = Boolean.TRUE.equals(this.exchangeSpecification.getExchangeSpecificParametersItem("Use_Sandbox"));
        boolean usePrime = Boolean.TRUE.equals(this.exchangeSpecification.getExchangeSpecificParametersItem("Use_Prime"));
        String apiUri = useSandbox ? (usePrime ? PRIME_SANDBOX_API_URI : SANDBOX_API_URI) : (usePrime ? PRIME_API_URI : API_URI);
        return exchangeSpec.getOverrideWebsocketApiUri() == null ? apiUri : exchangeSpec.getOverrideWebsocketApiUri();
    }

    private CoinbaseProWebsocketAuthData authData(ExchangeSpecification exchangeSpec) {
        CoinbaseProWebsocketAuthData authData = null;
        if (exchangeSpec.getApiKey() != null) {
            try {
                CoinbaseProAccountServiceRaw rawAccountService = (CoinbaseProAccountServiceRaw)this.getAccountService();
                authData = rawAccountService.getWebsocketAuthData();
            }
            catch (Exception e) {
                this.logger.warn("Failed attempting to acquire Websocket AuthData needed for private data on websocket.  Will only receive public information via API", (Throwable)e);
            }
        }
        return authData;
    }

    public Completable disconnect() {
        CoinbaseProStreamingService service = this.streamingService;
        this.streamingService = null;
        this.streamingMarketDataService = null;
        return service != null ? service.disconnect() : Completable.complete();
    }

    public Observable<Throwable> reconnectFailure() {
        return this.streamingService.subscribeReconnectFailure();
    }

    public Observable<Object> connectionSuccess() {
        return this.streamingService.subscribeConnectionSuccess();
    }

    public Observable<ConnectionStateModel.State> connectionStateObservable() {
        return this.streamingService.subscribeConnectionState();
    }

    public Observable<Object> connectionIdle() {
        return this.streamingService.subscribeIdle();
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification spec = super.getDefaultExchangeSpecification();
        spec.setShouldLoadRemoteMetaData(false);
        return spec;
    }

    public CoinbaseProStreamingMarketDataService getStreamingMarketDataService() {
        return this.streamingMarketDataService;
    }

    public StreamingAccountService getStreamingAccountService() {
        throw new NotYetImplementedForExchangeException();
    }

    public CoinbaseProStreamingTradeService getStreamingTradeService() {
        return this.streamingTradeService;
    }

    public void setChannelInactiveHandler(WebSocketClientHandler.WebSocketMessageHandler channelInactiveHandler) {
        this.streamingService.setChannelInactiveHandler(channelInactiveHandler);
    }

    public boolean isAlive() {
        return this.streamingService != null && this.streamingService.isSocketOpen();
    }

    public void useCompressedMessages(boolean compressedMessages) {
        this.streamingService.useCompressedMessages(compressedMessages);
    }

    public void setOverrideApiUri(String overrideApiUri) {
        this.getExchangeSpecification().setOverrideWebsocketApiUri(overrideApiUri);
    }

    public String getOverrideApiUri() {
        return this.getExchangeSpecification().getOverrideWebsocketApiUri();
    }
}

