/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.coinbasepro;

import info.bitrich.xchangestream.coinbasepro.dto.CoinbaseProWebSocketTransaction;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.knowm.xchange.coinbasepro.CoinbaseProAdapters;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProOrder;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.instrument.Instrument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoinbaseProStreamingAdapters {
    private static final Logger LOG = LoggerFactory.getLogger(CoinbaseProStreamingAdapters.class);

    static Order adaptOrder(CoinbaseProWebSocketTransaction s) {
        switch (s.getType()) {
            case "activate": 
            case "received": {
                return CoinbaseProAdapters.adaptOrder((CoinbaseProOrder)new CoinbaseProOrder(s.getOrderId(), s.getPrice(), s.getSize() == null ? BigDecimal.ZERO : s.getSize(), s.getProductId(), s.getSide(), s.getTime(), null, BigDecimal.ZERO, null, s.getType(), false, s.getType().equals("received") ? "limit" : "stop", null, null, null, null));
            }
        }
        Order.OrderType type = s.getSide().equals("buy") ? Order.OrderType.BID : Order.OrderType.ASK;
        CurrencyPair currencyPair = new CurrencyPair(s.getProductId().replace('-', '/'));
        return new LimitOrder.Builder(type, (Instrument)currencyPair).id(s.getOrderId()).orderStatus(CoinbaseProStreamingAdapters.adaptOrderStatus(s)).build();
    }

    private static Order.OrderStatus adaptOrderStatus(CoinbaseProWebSocketTransaction s) {
        if (s.getType().equals("done")) {
            if (s.getReason().equals("canceled")) {
                return Order.OrderStatus.CANCELED;
            }
            return Order.OrderStatus.FILLED;
        }
        if (s.getType().equals("match")) {
            return Order.OrderStatus.PARTIALLY_FILLED;
        }
        return Order.OrderStatus.NEW;
    }

    public static Date parseDate(String rawDate) {
        String modified;
        if (rawDate.length() > 23) {
            modified = rawDate.substring(0, 23);
        } else if (rawDate.endsWith("Z")) {
            switch (rawDate.length()) {
                case 20: {
                    modified = rawDate.substring(0, 19) + ".000";
                    break;
                }
                case 22: {
                    modified = rawDate.substring(0, 21) + "00";
                    break;
                }
                case 23: {
                    modified = rawDate.substring(0, 22) + "0";
                    break;
                }
                default: {
                    modified = rawDate;
                    break;
                }
            }
        } else {
            switch (rawDate.length()) {
                case 19: {
                    modified = rawDate + ".000";
                    break;
                }
                case 21: {
                    modified = rawDate + "00";
                    break;
                }
                case 22: {
                    modified = rawDate + "0";
                    break;
                }
                default: {
                    modified = rawDate;
                }
            }
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat.parse(modified);
        }
        catch (ParseException e) {
            LOG.warn("unable to parse rawDate={} modified={}", new Object[]{rawDate, modified, e});
            return null;
        }
    }
}

