/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.coinbasepro.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import info.bitrich.xchangestream.coinbasepro.dto.CoinbaseProOrderBookMode;
import info.bitrich.xchangestream.core.ProductSubscription;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.knowm.xchange.coinbasepro.dto.account.CoinbaseProWebsocketAuthData;
import org.knowm.xchange.currency.CurrencyPair;

public class CoinbaseProWebSocketSubscriptionMessage {
    public static final String TYPE = "type";
    public static final String CHANNELS = "channels";
    public static final String PRODUCT_IDS = "product_ids";
    public static final String NAME = "name";
    public static final String SIGNATURE = "signature";
    public static final String KEY = "key";
    public static final String PASSPHRASE = "passphrase";
    public static final String TIMESTAMP = "timestamp";
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="channels")
    private CoinbaseProProductSubscription[] channels;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="signature")
    String signature;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="key")
    String key;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="passphrase")
    String passphrase;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="timestamp")
    String timestamp;

    public CoinbaseProWebSocketSubscriptionMessage(String type, ProductSubscription product, CoinbaseProOrderBookMode orderBookMode, CoinbaseProWebsocketAuthData authData) {
        this.type = type;
        this.generateSubscriptionMessage(product, orderBookMode, authData);
    }

    public CoinbaseProWebSocketSubscriptionMessage(String type, String[] channelNames, CoinbaseProWebsocketAuthData authData) {
        this.type = type;
        this.generateSubscriptionMessage(channelNames, authData);
    }

    private String[] generateProductIds(CurrencyPair[] pairs) {
        ArrayList<String> productIds = new ArrayList<String>(pairs.length);
        for (CurrencyPair pair : pairs) {
            productIds.add(pair.base.toString() + "-" + pair.counter.toString());
        }
        return productIds.toArray(new String[0]);
    }

    private CoinbaseProProductSubscription generateCoinbaseProProduct(String name, CurrencyPair[] pairs, CoinbaseProWebsocketAuthData authData) {
        String[] productsIds = this.generateProductIds(pairs);
        return new CoinbaseProProductSubscription(name, productsIds, authData);
    }

    private void generateSubscriptionMessage(String[] channelNames, CoinbaseProWebsocketAuthData authData) {
        ArrayList<CoinbaseProProductSubscription> channels = new ArrayList<CoinbaseProProductSubscription>(3);
        for (String name : channelNames) {
            channels.add(new CoinbaseProProductSubscription(name, null, authData));
        }
        this.channels = channels.toArray(new CoinbaseProProductSubscription[0]);
    }

    private void generateSubscriptionMessage(ProductSubscription productSubscription, CoinbaseProOrderBookMode orderBookMode, CoinbaseProWebsocketAuthData authData) {
        ArrayList<CoinbaseProProductSubscription> channels = new ArrayList<CoinbaseProProductSubscription>(3);
        HashMap<String, List> pairs = new HashMap<String, List>(3);
        pairs.put(orderBookMode.getName(), productSubscription.getOrderBook());
        pairs.put("ticker", productSubscription.getTicker());
        pairs.put("matches", productSubscription.getTrades());
        if (authData != null) {
            ArrayList userCurrencies = new ArrayList();
            Stream.of(productSubscription.getUserTrades().stream(), productSubscription.getOrders().stream()).flatMap(s -> s).distinct().forEach(userCurrencies::add);
            pairs.put("user", userCurrencies);
        }
        for (Map.Entry product : pairs.entrySet()) {
            List currencyPairs = (List)product.getValue();
            if (currencyPairs == null || currencyPairs.size() == 0) continue;
            CoinbaseProProductSubscription coinbaseProProduct = this.generateCoinbaseProProduct((String)product.getKey(), ((List)product.getValue()).toArray(new CurrencyPair[0]), authData);
            channels.add(coinbaseProProduct);
        }
        this.channels = channels.toArray(new CoinbaseProProductSubscription[0]);
        if (authData != null) {
            this.key = authData.getKey();
            this.passphrase = authData.getPassphrase();
            this.signature = authData.getSignature();
            this.timestamp = String.valueOf(authData.getTimestamp());
        }
    }

    public String getType() {
        return this.type;
    }

    public CoinbaseProProductSubscription[] getChannels() {
        return this.channels;
    }

    class CoinbaseProProductSubscription {
        @JsonProperty(value="name")
        private final String name;
        @JsonProperty(value="product_ids")
        private final String[] productIds;

        public CoinbaseProProductSubscription(String name, String[] productIds, CoinbaseProWebsocketAuthData authData) {
            this.name = name;
            this.productIds = productIds;
        }

        public String getName() {
            return this.name;
        }

        public String[] getProductIds() {
            return this.productIds;
        }
    }
}

