/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.bitstamp.v2;

import com.fasterxml.jackson.databind.JsonNode;
import info.bitrich.xchangestream.bitstamp.v2.dto.BitstampWebSocketData;
import info.bitrich.xchangestream.bitstamp.v2.dto.BitstampWebSocketSubscriptionMessage;
import info.bitrich.xchangestream.service.netty.JsonNettyStreamingService;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandler;
import java.io.IOException;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitstampStreamingService
extends JsonNettyStreamingService {
    private static final Logger LOG = LoggerFactory.getLogger(BitstampStreamingService.class);
    private static final String JSON_CHANNEL = "channel";
    private static final String JSON_EVENT = "event";
    public static final String EVENT_ORDERBOOK = "data";
    public static final String EVENT_TRADE = "trade";
    private static final String EVENT_SUBSCRIPTION_SUCCEEDED = "bts:subscription_succeeded";
    private static final String EVENT_UNSUBSCRIPTION_SUCCEEDED = "bts:unsubscription_succeeded";

    public BitstampStreamingService(String apiUrl) {
        super(apiUrl, Integer.MAX_VALUE);
    }

    public BitstampStreamingService(String apiUrl, int maxFramePayloadLength, Duration connectionTimeout, Duration retryDuration, int idleTimeoutSeconds) {
        super(apiUrl, maxFramePayloadLength, connectionTimeout, retryDuration, idleTimeoutSeconds);
    }

    protected WebSocketClientExtensionHandler getWebSocketClientExtensionHandler() {
        return null;
    }

    protected String getChannelNameFromMessage(JsonNode message) throws IOException {
        JsonNode jsonNode = message.get(JSON_CHANNEL);
        if (jsonNode != null) {
            return jsonNode.asText();
        }
        throw new IOException("Channel name can't be evaluated from message");
    }

    protected void handleMessage(JsonNode message) {
        String event;
        JsonNode channelJsonNode = message.get(JSON_CHANNEL);
        JsonNode eventJsonNode = message.get(JSON_EVENT);
        if (channelJsonNode == null || eventJsonNode == null) {
            LOG.error("Received JSON message does not contain {} and {} fields. Skipped...", (Object)JSON_CHANNEL, (Object)JSON_EVENT);
            return;
        }
        String channel = channelJsonNode.asText();
        switch (event = eventJsonNode.asText()) {
            case "data": 
            case "trade": {
                if (!this.channels.containsKey(channel)) {
                    LOG.warn("The message has been received from disconnected channel '{}'. Skipped.", (Object)channel);
                    return;
                }
                super.handleMessage((Object)message);
                break;
            }
            case "bts:subscription_succeeded": {
                LOG.info("Channel {} has been successfully subscribed", (Object)channel);
                break;
            }
            case "bts:unsubscription_succeeded": {
                LOG.info("Channel {} has been successfully unsubscribed", (Object)channel);
                break;
            }
            default: {
                LOG.warn("Unsupported event type {} in message {}", (Object)event, (Object)message.toString());
            }
        }
    }

    public String getSubscribeMessage(String channelName, Object ... args) throws IOException {
        BitstampWebSocketSubscriptionMessage subscribeMessage = this.generateSubscribeMessage(channelName, "bts:subscribe");
        return this.objectMapper.writeValueAsString((Object)subscribeMessage);
    }

    public String getUnsubscribeMessage(String channelName, Object ... args) throws IOException {
        BitstampWebSocketSubscriptionMessage subscribeMessage = this.generateSubscribeMessage(channelName, "bts:unsubscribe");
        return this.objectMapper.writeValueAsString((Object)subscribeMessage);
    }

    private BitstampWebSocketSubscriptionMessage generateSubscribeMessage(String channelName, String channel) {
        return new BitstampWebSocketSubscriptionMessage(channel, new BitstampWebSocketData(channelName));
    }
}

