/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.bitstamp.v2;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import info.bitrich.xchangestream.bitstamp.dto.BitstampWebSocketTransaction;
import info.bitrich.xchangestream.bitstamp.v2.BitstampStreamingService;
import info.bitrich.xchangestream.core.StreamingMarketDataService;
import info.bitrich.xchangestream.service.netty.StreamingObjectMapperHelper;
import io.reactivex.Observable;
import org.knowm.xchange.bitstamp.BitstampAdapters;
import org.knowm.xchange.bitstamp.dto.marketdata.BitstampOrderBook;
import org.knowm.xchange.bitstamp.dto.marketdata.BitstampTransaction;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.instrument.Instrument;

public class BitstampStreamingMarketDataService
implements StreamingMarketDataService {
    private final BitstampStreamingService service;

    public BitstampStreamingMarketDataService(BitstampStreamingService service) {
        this.service = service;
    }

    public Observable<OrderBook> getFullOrderBook(CurrencyPair currencyPair, Object ... args) {
        return this.getOrderBook("diff_order_book", currencyPair, args);
    }

    public Observable<OrderBook> getOrderBook(CurrencyPair currencyPair, Object ... args) {
        return this.getOrderBook("order_book", currencyPair, args);
    }

    private Observable<OrderBook> getOrderBook(String channelPrefix, CurrencyPair currencyPair, Object ... args) {
        String channelName = channelPrefix + this.getChannelPostfix(currencyPair);
        return this.service.subscribeChannel(channelName, new Object[]{"data"}).map(s -> {
            ObjectMapper mapper = StreamingObjectMapperHelper.getObjectMapper();
            BitstampOrderBook orderBook = (BitstampOrderBook)mapper.treeToValue((TreeNode)s.get("data"), BitstampOrderBook.class);
            return BitstampAdapters.adaptOrderBook((BitstampOrderBook)orderBook, (CurrencyPair)currencyPair);
        });
    }

    public Observable<Ticker> getTicker(CurrencyPair currencyPair, Object ... args) {
        return this.getOrderBook(currencyPair, args).map(orderBook -> this.mapOrderBookToTicker(currencyPair, (OrderBook)orderBook));
    }

    private Ticker mapOrderBookToTicker(CurrencyPair currencyPair, OrderBook orderBook) {
        LimitOrder ask = (LimitOrder)orderBook.getAsks().get(0);
        LimitOrder bid = (LimitOrder)orderBook.getBids().get(0);
        return new Ticker.Builder().instrument((Instrument)currencyPair).bid(bid.getLimitPrice()).bidSize(bid.getOriginalAmount()).ask(ask.getLimitPrice()).askSize(ask.getOriginalAmount()).timestamp(orderBook.getTimeStamp()).build();
    }

    public Observable<Trade> getTrades(CurrencyPair currencyPair, Object ... args) {
        String channelName = "live_trades" + this.getChannelPostfix(currencyPair);
        return this.service.subscribeChannel(channelName, new Object[]{"trade"}).map(s -> {
            ObjectMapper mapper = StreamingObjectMapperHelper.getObjectMapper();
            BitstampWebSocketTransaction transactions = (BitstampWebSocketTransaction)((Object)((Object)mapper.treeToValue((TreeNode)s.get("data"), BitstampWebSocketTransaction.class)));
            return BitstampAdapters.adaptTrade((BitstampTransaction)transactions, (CurrencyPair)currencyPair, (int)1);
        });
    }

    private String getChannelPostfix(CurrencyPair currencyPair) {
        return "_" + currencyPair.base.toString().toLowerCase() + currencyPair.counter.toString().toLowerCase();
    }
}

