/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.bitstamp.v2;

import info.bitrich.xchangestream.bitstamp.v2.BitstampStreamingMarketDataService;
import info.bitrich.xchangestream.bitstamp.v2.BitstampStreamingService;
import info.bitrich.xchangestream.core.ProductSubscription;
import info.bitrich.xchangestream.core.StreamingExchange;
import info.bitrich.xchangestream.core.StreamingMarketDataService;
import info.bitrich.xchangestream.service.netty.ConnectionStateModel;
import info.bitrich.xchangestream.service.netty.NettyStreamingService;
import io.reactivex.Completable;
import io.reactivex.Observable;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.bitstamp.BitstampExchange;

public class BitstampStreamingExchange
extends BitstampExchange
implements StreamingExchange {
    private static final String API_URI = "wss://ws.bitstamp.net";
    private final BitstampStreamingService streamingService = new BitstampStreamingService("wss://ws.bitstamp.net");
    private BitstampStreamingMarketDataService streamingMarketDataService;

    protected void initServices() {
        super.initServices();
        this.applyStreamingSpecification(this.getExchangeSpecification(), (NettyStreamingService)this.streamingService);
        this.streamingMarketDataService = new BitstampStreamingMarketDataService(this.streamingService);
    }

    public Completable connect(ProductSubscription ... args) {
        return this.streamingService.connect();
    }

    public Completable disconnect() {
        return this.streamingService.disconnect();
    }

    public boolean isAlive() {
        return this.streamingService.isSocketOpen();
    }

    public Observable<Throwable> reconnectFailure() {
        return this.streamingService.subscribeReconnectFailure();
    }

    public Observable<Object> connectionSuccess() {
        return this.streamingService.subscribeConnectionSuccess();
    }

    public Observable<ConnectionStateModel.State> connectionStateObservable() {
        return this.streamingService.subscribeConnectionState();
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification spec = super.getDefaultExchangeSpecification();
        spec.setShouldLoadRemoteMetaData(false);
        return spec;
    }

    public StreamingMarketDataService getStreamingMarketDataService() {
        return this.streamingMarketDataService;
    }

    public void useCompressedMessages(boolean compressedMessages) {
        this.streamingService.useCompressedMessages(compressedMessages);
    }
}

