/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.bitmex.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import info.bitrich.xchangestream.bitmex.dto.BitmexMarketDataEvent;
import java.math.BigDecimal;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.instrument.Instrument;

public class BitmexTicker
extends BitmexMarketDataEvent {
    private final String timestamp;
    private final String symbol;
    private final BigDecimal bidSize;
    private final BigDecimal bidPrice;
    private final BigDecimal askPrice;
    private final BigDecimal askSize;

    public BitmexTicker(@JsonProperty(value="timestamp") String timestamp, @JsonProperty(value="symbol") String symbol, @JsonProperty(value="bidSize") BigDecimal bidSize, @JsonProperty(value="bidPrice") BigDecimal bidPrice, @JsonProperty(value="askPrice") BigDecimal askPrice, @JsonProperty(value="askSize") BigDecimal askSize) {
        super(symbol, timestamp);
        this.timestamp = timestamp;
        this.symbol = symbol;
        this.bidSize = bidSize;
        this.bidPrice = bidPrice;
        this.askPrice = askPrice;
        this.askSize = askSize;
    }

    @Override
    public String getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public BigDecimal getBidSize() {
        return this.bidSize;
    }

    public BigDecimal getBidPrice() {
        return this.bidPrice;
    }

    public BigDecimal getAskPrice() {
        return this.askPrice;
    }

    public BigDecimal getAskSize() {
        return this.askSize;
    }

    public Ticker toTicker() {
        return new Ticker.Builder().ask(this.askPrice).bidSize(this.bidSize).bid(this.bidPrice).askSize(this.askSize).timestamp(this.getDate()).instrument((Instrument)this.getCurrencyPair()).build();
    }
}

