/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.bitmex.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import info.bitrich.xchangestream.bitmex.dto.BitmexMarketDataEvent;
import java.math.BigDecimal;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.instrument.Instrument;

public class BitmexLimitOrder
extends BitmexMarketDataEvent {
    public static final String ASK_SIDE = "Sell";
    public static final String BID_SIDE = "Buy";
    protected final String id;
    protected final String side;
    protected final BigDecimal price;
    protected final BigDecimal size;

    @JsonCreator
    public BitmexLimitOrder(@JsonProperty(value="symbol") String symbol, @JsonProperty(value="id") String id, @JsonProperty(value="side") String side, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="size") BigDecimal size) {
        super(symbol, null);
        this.id = id;
        this.side = side;
        this.price = price;
        this.size = size;
    }

    public BitmexLimitOrder(String symbol, String id, String side, BigDecimal price, BigDecimal size, String timestamp) {
        super(symbol, timestamp);
        this.id = id;
        this.side = side;
        this.price = price;
        this.size = size;
    }

    public String getId() {
        return this.id;
    }

    public String getSide() {
        return this.side;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getSize() {
        return this.size;
    }

    public Order.OrderType getOrderSide() {
        return this.side.equals(ASK_SIDE) ? Order.OrderType.ASK : Order.OrderType.BID;
    }

    public LimitOrder toLimitOrder() {
        CurrencyPair pair = this.getCurrencyPair();
        Order.OrderType orderType = this.getOrderSide();
        return new LimitOrder(orderType, this.size, (Instrument)pair, this.id, null, this.price);
    }
}

