/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.bitmex;

import info.bitrich.xchangestream.bitmex.BitmexStreamingMarketDataService;
import info.bitrich.xchangestream.bitmex.BitmexStreamingService;
import info.bitrich.xchangestream.core.ProductSubscription;
import info.bitrich.xchangestream.core.StreamingExchange;
import info.bitrich.xchangestream.core.StreamingMarketDataService;
import info.bitrich.xchangestream.service.netty.ConnectionStateModel;
import info.bitrich.xchangestream.service.netty.NettyStreamingService;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.bitmex.BitmexExchange;

public class BitmexStreamingExchange
extends BitmexExchange
implements StreamingExchange {
    private static final String API_URI = "wss://www.bitmex.com/realtime";
    private static final String TESTNET_API_URI = "wss://testnet.bitmex.com/realtime";
    private BitmexStreamingService streamingService;
    private BitmexStreamingMarketDataService streamingMarketDataService;

    protected void initServices() {
        super.initServices();
        this.streamingService = this.createStreamingService();
        this.streamingMarketDataService = new BitmexStreamingMarketDataService(this.streamingService, this);
    }

    public Completable connect(ProductSubscription ... args) {
        return this.streamingService.connect();
    }

    private BitmexStreamingService createStreamingService() {
        ExchangeSpecification exchangeSpec = this.getExchangeSpecification();
        Boolean useSandbox = (Boolean)exchangeSpec.getExchangeSpecificParametersItem("Use_Sandbox");
        String uri = useSandbox == null || useSandbox == false ? API_URI : TESTNET_API_URI;
        BitmexStreamingService streamingService = new BitmexStreamingService(uri, exchangeSpec.getApiKey(), exchangeSpec.getSecretKey());
        this.applyStreamingSpecification(exchangeSpec, (NettyStreamingService)streamingService);
        return streamingService;
    }

    public Completable disconnect() {
        return this.streamingService.disconnect();
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification spec = super.getDefaultExchangeSpecification();
        spec.setShouldLoadRemoteMetaData(false);
        return spec;
    }

    public StreamingMarketDataService getStreamingMarketDataService() {
        return this.streamingMarketDataService;
    }

    public Observable<Throwable> reconnectFailure() {
        return this.streamingService.subscribeReconnectFailure();
    }

    public Observable<Object> connectionSuccess() {
        return this.streamingService.subscribeConnectionSuccess();
    }

    public Observable<ConnectionStateModel.State> connectionStateObservable() {
        return this.streamingService.subscribeConnectionState();
    }

    public boolean isAlive() {
        return this.streamingService.isSocketOpen();
    }

    public void useCompressedMessages(boolean compressedMessages) {
        this.streamingService.useCompressedMessages(compressedMessages);
    }

    public Observable<Long> messageDelay() {
        return Observable.create(delayEmitter -> this.streamingService.addDelayEmitter((ObservableEmitter<Long>)delayEmitter));
    }

    public void resubscribeChannels() {
        this.streamingService.resubscribeChannels();
    }

    public BitmexStreamingService getStreamingService() {
        return this.streamingService;
    }
}

