/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.bitmex;

import java.nio.charset.Charset;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class BitmexAuthenticator {
    public static String getSHA256String(String str, String key) {
        try {
            Charset asciiCs = Charset.forName("US-ASCII");
            SecretKeySpec signingKey = new SecretKeySpec(asciiCs.encode(key).array(), "HmacSHA256");
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            sha256_HMAC.init(signingKey);
            byte[] mac_data = sha256_HMAC.doFinal(asciiCs.encode(str).array());
            StringBuilder result = new StringBuilder();
            for (byte element : mac_data) {
                result.append(Integer.toString((element & 0xFF) + 256, 16).substring(1));
            }
            return result.toString().toUpperCase();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String generateSignature(String secret, String verb, String url, String nonce, String data) {
        String message = verb + url + nonce + data;
        return BitmexAuthenticator.getSHA256String(message, secret);
    }
}

