/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.bitmex.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import info.bitrich.xchangestream.bitmex.dto.BitmexFunding;
import info.bitrich.xchangestream.bitmex.dto.BitmexLimitOrder;
import info.bitrich.xchangestream.bitmex.dto.BitmexOrder;
import info.bitrich.xchangestream.bitmex.dto.BitmexOrderbook;
import info.bitrich.xchangestream.bitmex.dto.BitmexTicker;
import info.bitrich.xchangestream.bitmex.dto.BitmexTrade;
import info.bitrich.xchangestream.bitmex.dto.RawOrderBook;
import info.bitrich.xchangestream.service.netty.StreamingObjectMapperHelper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitmexWebSocketTransaction {
    private static final Logger log = LoggerFactory.getLogger(BitmexWebSocketTransaction.class);
    private static final ObjectMapper mapper = StreamingObjectMapperHelper.getObjectMapper();
    private final String table;
    private final String action;
    private final JsonNode data;

    public BitmexWebSocketTransaction(@JsonProperty(value="table") String table, @JsonProperty(value="action") String action, @JsonProperty(value="data") JsonNode data) {
        this.table = table;
        this.action = action;
        this.data = data;
    }

    public BitmexLimitOrder[] toBitmexOrderbookLevels() {
        BitmexLimitOrder[] levels = new BitmexLimitOrder[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            JsonNode jsonLevel = this.data.get(i);
            try {
                levels[i] = (BitmexLimitOrder)mapper.treeToValue((TreeNode)jsonLevel, BitmexLimitOrder.class);
                continue;
            }
            catch (IOException e) {
                log.error("limit order mapping exception", (Throwable)e);
            }
        }
        return levels;
    }

    public BitmexOrderbook toBitmexOrderbook() {
        BitmexLimitOrder[] levels = this.toBitmexOrderbookLevels();
        return new BitmexOrderbook(levels);
    }

    public BitmexTicker toBitmexTicker() {
        BitmexTicker bitmexTicker = null;
        try {
            bitmexTicker = (BitmexTicker)mapper.treeToValue((TreeNode)this.data.get(0), BitmexTicker.class);
        }
        catch (IOException e) {
            log.error("ticker mapping exception", (Throwable)e);
        }
        return bitmexTicker;
    }

    public BitmexTrade[] toBitmexTrades() {
        BitmexTrade[] trades = new BitmexTrade[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            JsonNode jsonTrade = this.data.get(i);
            try {
                trades[i] = (BitmexTrade)mapper.treeToValue((TreeNode)jsonTrade, BitmexTrade.class);
                continue;
            }
            catch (IOException e) {
                log.error("trade array mapping exception", (Throwable)e);
            }
        }
        return trades;
    }

    public BitmexOrder[] toBitmexOrders() {
        BitmexOrder[] orders = new BitmexOrder[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            JsonNode jsonOrder = this.data.get(i);
            try {
                orders[i] = (BitmexOrder)mapper.treeToValue((TreeNode)jsonOrder, BitmexOrder.class);
                continue;
            }
            catch (IOException e) {
                log.error("orders mapping exception", (Throwable)e);
            }
        }
        return orders;
    }

    public BitmexFunding toBitmexFunding() {
        BitmexFunding funding = null;
        try {
            funding = (BitmexFunding)mapper.treeToValue((TreeNode)this.data.get(0), BitmexFunding.class);
        }
        catch (IOException e) {
            log.error("funding mapping exception", (Throwable)e);
        }
        return funding;
    }

    public RawOrderBook toRawOrderBook() {
        try {
            return (RawOrderBook)mapper.treeToValue((TreeNode)this.data.get(0), RawOrderBook.class);
        }
        catch (JsonProcessingException e) {
            log.error("raw order book mapping exception", (Throwable)e);
            return null;
        }
    }

    public String getTable() {
        return this.table;
    }

    public String getAction() {
        return this.action;
    }

    public JsonNode getData() {
        return this.data;
    }
}

