/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.bitmex.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import info.bitrich.xchangestream.bitmex.dto.BitmexLimitOrder;
import java.math.BigDecimal;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.Trade;

public class BitmexTrade
extends BitmexLimitOrder {
    private String trdMatchID;

    @JsonCreator
    public BitmexTrade(@JsonProperty(value="symbol") String symbol, @JsonProperty(value="side") String side, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="size") BigDecimal size, @JsonProperty(value="trdMatchID") String trdMatchID, @JsonProperty(value="timestamp") String timestamp) {
        super(symbol, "", side, price, size, timestamp);
        this.trdMatchID = trdMatchID;
    }

    @Override
    public String getTimestamp() {
        return this.timestamp;
    }

    public String getTrdMatchID() {
        return this.trdMatchID;
    }

    public Trade toTrade() {
        CurrencyPair pair = this.getCurrencyPair();
        Order.OrderType orderType = this.getOrderSide();
        return new Trade.Builder().type(orderType).originalAmount(this.size).currencyPair(pair).price(this.price).timestamp(this.getDate()).id(this.trdMatchID).build();
    }
}

