/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.bitmex.dto;

import info.bitrich.xchangestream.bitmex.dto.BitmexLimitOrder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.trade.LimitOrder;

public class BitmexOrderbook {
    private SortedMap<BigDecimal, BitmexLimitOrder> asks;
    private SortedMap<BigDecimal, BitmexLimitOrder> bids;
    private Map<String, BigDecimal> askIds = new HashMap<String, BigDecimal>();
    private Map<String, BigDecimal> bidIds = new HashMap<String, BigDecimal>();

    public BitmexOrderbook() {
        this.asks = new TreeMap<BigDecimal, BitmexLimitOrder>();
        this.bids = new TreeMap(Collections.reverseOrder());
    }

    public BitmexOrderbook(BitmexLimitOrder[] levels) {
        this();
        this.createFromLevels(levels);
    }

    public void createFromLevels(BitmexLimitOrder[] levels) {
        for (BitmexLimitOrder level : levels) {
            SortedMap<BigDecimal, BitmexLimitOrder> orderBookSide = level.getSide().equals("Sell") ? this.asks : this.bids;
            Map<String, BigDecimal> orderBookSideIds = level.getSide().equals("Sell") ? this.askIds : this.bidIds;
            orderBookSide.put(level.getPrice(), level);
            orderBookSideIds.put(level.getId(), level.getPrice());
        }
    }

    public void updateLevels(BitmexLimitOrder[] levels, String action) {
        for (BitmexLimitOrder level : levels) {
            this.updateLevel(level, action);
        }
    }

    public void updateLevel(BitmexLimitOrder level, String action) {
        Map<String, BigDecimal> orderBookSideIds;
        SortedMap<BigDecimal, BitmexLimitOrder> orderBookSide = level.getSide().equals("Sell") ? this.asks : this.bids;
        Map<String, BigDecimal> map = orderBookSideIds = level.getSide().equals("Sell") ? this.askIds : this.bidIds;
        if (action.equals("insert")) {
            orderBookSide.put(level.getPrice(), level);
            orderBookSideIds.put(level.getId(), level.getPrice());
        } else if (action.equals("delete") || action.equals("update")) {
            boolean shouldDelete = action.equals("delete");
            String id = level.getId();
            BigDecimal price = orderBookSideIds.get(id);
            orderBookSide.remove(price);
            orderBookSideIds.remove(id);
            if (!shouldDelete) {
                BitmexLimitOrder modifiedLevel = new BitmexLimitOrder(level.getSymbol(), level.getId(), level.getSide(), price, level.getSize());
                orderBookSide.put(price, modifiedLevel);
                orderBookSideIds.put(id, price);
            }
        }
    }

    public BitmexLimitOrder[] getLevels(String side) {
        SortedMap<BigDecimal, BitmexLimitOrder> orderBookSide = side.equals("Sell") ? this.asks : this.bids;
        return orderBookSide.values().toArray(new BitmexLimitOrder[orderBookSide.size()]);
    }

    public BitmexLimitOrder[] getAsks() {
        return this.getLevels("Sell");
    }

    public BitmexLimitOrder[] getBids() {
        return this.getLevels("Buy");
    }

    public static List<LimitOrder> toLimitOrders(BitmexLimitOrder[] levels) {
        if (levels == null || levels.length == 0) {
            return null;
        }
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>(levels.length);
        for (BitmexLimitOrder level : levels) {
            LimitOrder limitOrder = level.toLimitOrder();
            limitOrders.add(limitOrder);
        }
        return limitOrders;
    }

    public OrderBook toOrderbook() {
        List<LimitOrder> orderbookAsks = BitmexOrderbook.toLimitOrders(this.getAsks());
        List<LimitOrder> orderbookBids = BitmexOrderbook.toLimitOrders(this.getBids());
        return new OrderBook(null, orderbookAsks, orderbookBids);
    }
}

