/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.bitmex.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import info.bitrich.xchangestream.bitmex.dto.BitmexMarketDataEvent;
import java.math.BigDecimal;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.instrument.Instrument;

public class BitmexOrder
extends BitmexMarketDataEvent {
    private String orderID;
    private int account;
    private String side;
    private BigDecimal price;
    private BigDecimal avgPx;
    private String ordType;
    private OrderStatus ordStatus;
    private String clOrdID;
    private BigDecimal orderQty;
    private BigDecimal cumQty;
    private boolean workingIndicator;

    public boolean isNotWorkingIndicator() {
        return !this.workingIndicator;
    }

    @JsonCreator
    public BitmexOrder(@JsonProperty(value="symbol") String symbol, @JsonProperty(value="timestamp") String timestamp, @JsonProperty(value="orderID") String orderID, @JsonProperty(value="account") int account, @JsonProperty(value="side") String side, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="avgPx") BigDecimal avgPx, @JsonProperty(value="ordType") String ordType, @JsonProperty(value="ordStatus") String ordStatus, @JsonProperty(value="clOrdID") String clOrdID, @JsonProperty(value="orderQty") BigDecimal orderQty, @JsonProperty(value="cumQty") BigDecimal cumQty, @JsonProperty(value="workingIndicator") boolean workingIndicator) {
        super(symbol, timestamp);
        this.orderID = orderID;
        this.account = account;
        this.side = side;
        this.price = price;
        this.avgPx = avgPx;
        this.ordType = ordType;
        try {
            this.ordStatus = OrderStatus.valueOf(ordStatus.toUpperCase());
        }
        catch (Exception e) {
            this.ordStatus = OrderStatus.UNKNOW;
        }
        this.clOrdID = clOrdID;
        this.orderQty = orderQty;
        this.cumQty = cumQty;
        this.workingIndicator = workingIndicator;
    }

    public Order toOrder() {
        Object order = this.ordType.equals("Market") ? new MarketOrder.Builder(this.side.equals("Buy") ? Order.OrderType.BID : Order.OrderType.ASK, (Instrument)new CurrencyPair(this.symbol.substring(0, 3), this.symbol.substring(3, this.symbol.length()))) : new LimitOrder.Builder(this.side.equals("Buy") ? Order.OrderType.BID : Order.OrderType.ASK, (Instrument)new CurrencyPair(this.symbol.substring(0, 3), this.symbol.substring(3, this.symbol.length())));
        order.id(this.orderID).averagePrice(this.avgPx).originalAmount(this.orderQty).cumulativeAmount(this.cumQty);
        switch (this.ordStatus) {
            case NEW: {
                order.orderStatus(Order.OrderStatus.NEW);
                break;
            }
            case PARTIALLYFILLED: {
                order.orderStatus(Order.OrderStatus.PARTIALLY_FILLED);
                break;
            }
            case FILLED: {
                order.orderStatus(Order.OrderStatus.FILLED);
                break;
            }
            case TBD: {
                order.orderStatus(Order.OrderStatus.PENDING_CANCEL);
                break;
            }
            case CANCELED: {
                order.orderStatus(Order.OrderStatus.CANCELED);
                break;
            }
            case REJECTED: {
                order.orderStatus(Order.OrderStatus.REJECTED);
            }
            default: {
                order.orderStatus(Order.OrderStatus.UNKNOWN);
            }
        }
        if (this.ordType.equals("Market")) {
            return order.build();
        }
        return ((LimitOrder.Builder)order).build();
    }

    public String getOrderID() {
        return this.orderID;
    }

    public int getAccount() {
        return this.account;
    }

    public String getSide() {
        return this.side;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getAvgPx() {
        return this.avgPx;
    }

    public String getOrdType() {
        return this.ordType;
    }

    public OrderStatus getOrdStatus() {
        return this.ordStatus;
    }

    public String getClOrdID() {
        return this.clOrdID;
    }

    public BigDecimal getOrderQty() {
        return this.orderQty;
    }

    public BigDecimal getCumQty() {
        return this.cumQty;
    }

    public boolean isWorkingIndicator() {
        return this.workingIndicator;
    }

    public static enum OrderStatus {
        NEW,
        PARTIALLYFILLED,
        FILLED,
        TBD,
        CANCELED,
        REJECTED,
        UNKNOW;

    }
}

