/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.bitmex.dto;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;

public class BitmexMarketDataEvent {
    public static final String BITMEX_TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    protected String timestamp;
    protected String symbol;

    public BitmexMarketDataEvent(String symbol, String timestamp) {
        this.timestamp = timestamp;
        this.symbol = symbol;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public CurrencyPair getCurrencyPair() {
        String base = this.symbol.substring(0, 3);
        String counter = this.symbol.substring(3);
        return new CurrencyPair(Currency.getInstance((String)base), Currency.getInstance((String)counter));
    }

    public Date getDate() {
        SimpleDateFormat formatter = new SimpleDateFormat(BITMEX_TIMESTAMP_FORMAT);
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = null;
        try {
            date = formatter.parse(this.timestamp);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }
}

