/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.bitmex;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import info.bitrich.xchangestream.bitmex.BitmexStreamingService;
import info.bitrich.xchangestream.bitmex.dto.BitmexExecution;
import info.bitrich.xchangestream.bitmex.dto.BitmexFunding;
import info.bitrich.xchangestream.bitmex.dto.BitmexLimitOrder;
import info.bitrich.xchangestream.bitmex.dto.BitmexOrderbook;
import info.bitrich.xchangestream.bitmex.dto.BitmexTicker;
import info.bitrich.xchangestream.bitmex.dto.BitmexTrade;
import info.bitrich.xchangestream.bitmex.dto.BitmexWebSocketTransaction;
import info.bitrich.xchangestream.bitmex.dto.RawOrderBook;
import info.bitrich.xchangestream.core.StreamingMarketDataService;
import info.bitrich.xchangestream.service.netty.StreamingObjectMapperHelper;
import io.reactivex.Observable;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.SortedMap;
import java.util.TreeMap;
import org.knowm.xchange.bitmex.BitmexExchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.instrument.Instrument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitmexStreamingMarketDataService
implements StreamingMarketDataService {
    private static final Logger LOG = LoggerFactory.getLogger(BitmexStreamingMarketDataService.class);
    private final ObjectMapper objectMapper = StreamingObjectMapperHelper.getObjectMapper();
    private final BitmexStreamingService streamingService;
    private final BitmexExchange bitmexExchange;
    private final SortedMap<String, BitmexOrderbook> orderbooks = new TreeMap<String, BitmexOrderbook>();

    public BitmexStreamingMarketDataService(BitmexStreamingService streamingService, BitmexExchange bitmexExchange) {
        this.streamingService = streamingService;
        this.streamingService.subscribeConnectionSuccess().subscribe(o -> {
            LOG.info("Bitmex connection succeeded. Clearing orderbooks.");
            this.orderbooks.clear();
        });
        this.bitmexExchange = bitmexExchange;
    }

    private String getBitmexSymbol(CurrencyPair currencyPair) {
        return currencyPair.base.toString() + currencyPair.counter.toString();
    }

    public Observable<OrderBook> getOrderBook(CurrencyPair currencyPair, Object ... args) {
        String instrument = this.getBitmexSymbol(currencyPair);
        String channelName = String.format("orderBookL2:%s", instrument);
        boolean fullBook = false;
        if (args != null && args.length > 0) {
            if (args[0] instanceof String && "10".equals(args[0])) {
                channelName = String.format("orderBook10:%s", instrument);
                fullBook = true;
            } else {
                channelName = String.format("orderBookL2_25:%s", instrument);
            }
        }
        if (fullBook) {
            return this.streamingService.subscribeBitmexChannel(channelName).map(s -> {
                RawOrderBook orderBook = s.toRawOrderBook();
                if (orderBook != null) {
                    ArrayList asks = new ArrayList(orderBook.getAsks().size());
                    ArrayList bids = new ArrayList(orderBook.getBids().size());
                    orderBook.getAsks().forEach(r -> {
                        LimitOrder order = new LimitOrder.Builder(Order.OrderType.ASK, (Instrument)currencyPair).originalAmount((BigDecimal)r.get(1)).limitPrice((BigDecimal)r.get(0)).build();
                        asks.add(order);
                    });
                    orderBook.getBids().forEach(r -> {
                        LimitOrder order = new LimitOrder.Builder(Order.OrderType.BID, (Instrument)currencyPair).originalAmount((BigDecimal)r.get(1)).limitPrice((BigDecimal)r.get(0)).build();
                        bids.add(order);
                    });
                    return new OrderBook(new Date(), asks, bids);
                }
                return new OrderBook(new Date(), Collections.emptyList(), Collections.emptyList());
            });
        }
        return this.streamingService.subscribeBitmexChannel(channelName).map(s -> {
            BitmexOrderbook orderbook;
            String action = s.getAction();
            if ("partial".equals(action)) {
                orderbook = s.toBitmexOrderbook();
                this.orderbooks.put(instrument, orderbook);
            } else {
                orderbook = (BitmexOrderbook)this.orderbooks.get(instrument);
                if (orderbook == null) {
                    return new OrderBook(new Date(), Collections.emptyList(), Collections.emptyList());
                }
                BitmexLimitOrder[] levels = s.toBitmexOrderbookLevels();
                orderbook.updateLevels(levels, action);
            }
            return orderbook.toOrderbook();
        });
    }

    public Observable<RawOrderBook> getRawOrderBook(CurrencyPair currencyPair) {
        String instrument = this.getBitmexSymbol(currencyPair);
        String channelName = String.format("orderBook10:%s", instrument);
        return this.streamingService.subscribeBitmexChannel(channelName).map(s -> s.toRawOrderBook());
    }

    public Observable<BitmexTicker> getRawTicker(CurrencyPair currencyPair) {
        String instrument = this.getBitmexSymbol(currencyPair);
        String channelName = String.format("quote:%s", instrument);
        return this.streamingService.subscribeBitmexChannel(channelName).map(s -> s.toBitmexTicker());
    }

    public Observable<Ticker> getTicker(CurrencyPair currencyPair, Object ... args) {
        String instrument = this.getBitmexSymbol(currencyPair);
        String channelName = String.format("quote:%s", instrument);
        return this.streamingService.subscribeBitmexChannel(channelName).map(s -> {
            BitmexTicker bitmexTicker = s.toBitmexTicker();
            return bitmexTicker.toTicker();
        });
    }

    public Observable<Trade> getTrades(CurrencyPair currencyPair, Object ... args) {
        String instrument = this.getBitmexSymbol(currencyPair);
        String channelName = String.format("trade:%s", instrument);
        return this.streamingService.subscribeBitmexChannel(channelName).flatMapIterable(s -> {
            BitmexTrade[] bitmexTrades = s.toBitmexTrades();
            ArrayList<Trade> trades = new ArrayList<Trade>(bitmexTrades.length);
            for (BitmexTrade bitmexTrade : bitmexTrades) {
                trades.add(bitmexTrade.toTrade());
            }
            return trades;
        });
    }

    public Observable<BitmexExecution> getRawExecutions(String symbol) {
        return this.streamingService.subscribeBitmexChannel("execution:" + symbol).flatMapIterable(s -> {
            JsonNode executions = s.getData();
            ArrayList<BitmexExecution> bitmexExecutions = new ArrayList<BitmexExecution>(executions.size());
            for (JsonNode execution : executions) {
                bitmexExecutions.add((BitmexExecution)this.objectMapper.treeToValue((TreeNode)execution, BitmexExecution.class));
            }
            return bitmexExecutions;
        });
    }

    public void enableDeadManSwitch() throws IOException {
        this.enableDeadManSwitch(15000L, 60000L);
    }

    public void enableDeadManSwitch(long rate, long timeout) throws IOException {
        this.streamingService.enableDeadMansSwitch(rate, timeout);
    }

    public boolean isDeadManSwitchEnabled() throws IOException {
        return this.streamingService.isDeadMansSwitchEnabled();
    }

    public void disableDeadMansSwitch() throws IOException {
        this.streamingService.disableDeadMansSwitch();
    }

    public Observable<BitmexFunding> getRawFunding() {
        String channelName = "funding";
        return this.streamingService.subscribeBitmexChannel(channelName).map(BitmexWebSocketTransaction::toBitmexFunding);
    }
}

