/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.bitfinex.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexTrade;

@JsonFormat(shape=JsonFormat.Shape.ARRAY)
public class BitfinexWebSocketTrade {
    public long tradeId;
    public long timestamp;
    public BigDecimal amount;
    public BigDecimal price;

    public BitfinexWebSocketTrade() {
    }

    public BitfinexWebSocketTrade(long tradeId, long timestamp, BigDecimal amount, BigDecimal price) {
        this.tradeId = tradeId;
        this.timestamp = timestamp;
        this.amount = amount;
        this.price = price;
    }

    public long getTradeId() {
        return this.tradeId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BitfinexTrade toBitfinexTrade() {
        String type = this.amount.compareTo(BigDecimal.ZERO) < 0 ? "sell" : "buy";
        return new BitfinexTrade(this.price, this.amount.abs(), this.timestamp / 1000L, "bitfinex", this.tradeId, type);
    }
}

