/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.bitfinex.dto;

import info.bitrich.xchangestream.bitfinex.dto.BitfinexOrderbookLevel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexDepth;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexLevel;

public class BitfinexOrderbook {
    private Map<BigDecimal, BitfinexOrderbookLevel> asks;
    private Map<BigDecimal, BitfinexOrderbookLevel> bids;

    public BitfinexOrderbook(BitfinexOrderbookLevel[] levels) {
        this.createFromLevels(levels);
    }

    private void createFromLevels(BitfinexOrderbookLevel[] levels) {
        this.asks = new HashMap<BigDecimal, BitfinexOrderbookLevel>(levels.length / 2);
        this.bids = new HashMap<BigDecimal, BitfinexOrderbookLevel>(levels.length / 2);
        for (BitfinexOrderbookLevel level : levels) {
            if (level.getCount().compareTo(BigDecimal.ZERO) == 0) continue;
            if (level.getAmount().compareTo(BigDecimal.ZERO) > 0) {
                this.bids.put(level.getPrice(), level);
                continue;
            }
            this.asks.put(level.getPrice(), new BitfinexOrderbookLevel(level.getPrice(), level.getCount(), level.getAmount().abs()));
        }
    }

    public synchronized BitfinexDepth toBitfinexDepth() {
        TreeMap<BigDecimal, BitfinexOrderbookLevel> bitfinexLevelAsks = new TreeMap<BigDecimal, BitfinexOrderbookLevel>();
        TreeMap bitfinexLevelBids = new TreeMap(Collections.reverseOrder());
        for (Map.Entry<BigDecimal, BitfinexOrderbookLevel> level : this.asks.entrySet()) {
            bitfinexLevelAsks.put(level.getValue().getPrice(), level.getValue());
        }
        for (Map.Entry<BigDecimal, BitfinexOrderbookLevel> level : this.bids.entrySet()) {
            bitfinexLevelBids.put(level.getValue().getPrice(), level.getValue());
        }
        ArrayList<BitfinexLevel> askLevels = new ArrayList<BitfinexLevel>(this.asks.size());
        ArrayList<BitfinexLevel> bidLevels = new ArrayList<BitfinexLevel>(this.bids.size());
        for (Map.Entry level : bitfinexLevelAsks.entrySet()) {
            askLevels.add(((BitfinexOrderbookLevel)level.getValue()).toBitfinexLevel());
        }
        for (Map.Entry level : bitfinexLevelBids.entrySet()) {
            bidLevels.add(((BitfinexOrderbookLevel)level.getValue()).toBitfinexLevel());
        }
        return new BitfinexDepth(askLevels.toArray(new BitfinexLevel[askLevels.size()]), bidLevels.toArray(new BitfinexLevel[bidLevels.size()]));
    }

    public synchronized void updateLevel(BitfinexOrderbookLevel level) {
        Map<BigDecimal, BitfinexOrderbookLevel> side;
        BitfinexOrderbookLevel bidAskLevel = level;
        if (level.getAmount().compareTo(BigDecimal.ZERO) < 0) {
            side = this.asks;
            bidAskLevel = new BitfinexOrderbookLevel(level.getPrice(), level.getCount(), level.getAmount().abs());
        } else {
            side = this.bids;
        }
        boolean shouldDelete = bidAskLevel.getCount().compareTo(BigDecimal.ZERO) == 0;
        side.remove(bidAskLevel.getPrice());
        if (!shouldDelete) {
            side.put(bidAskLevel.getPrice(), bidAskLevel);
        }
    }
}

