/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.bitfinex;

import info.bitrich.xchangestream.bitfinex.BitfinexStreamingAdapters;
import info.bitrich.xchangestream.bitfinex.BitfinexStreamingService;
import info.bitrich.xchangestream.bitfinex.dto.BitfinexWebSocketAuthOrder;
import info.bitrich.xchangestream.bitfinex.dto.BitfinexWebSocketAuthPreTrade;
import info.bitrich.xchangestream.bitfinex.dto.BitfinexWebSocketAuthTrade;
import info.bitrich.xchangestream.core.StreamingTradeService;
import io.reactivex.Observable;
import java.util.function.Function;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.exceptions.ExchangeSecurityException;

public class BitfinexStreamingTradeService
implements StreamingTradeService {
    private final BitfinexStreamingService service;

    public BitfinexStreamingTradeService(BitfinexStreamingService service) {
        this.service = service;
    }

    public Observable<Order> getOrderChanges() {
        return this.getRawAuthenticatedOrders().filter(o -> o.getId() != 0L).map(BitfinexStreamingAdapters::adaptOrder).doOnNext(o -> {
            this.service.scheduleCalculatedBalanceFetch(o.getCurrencyPair().base.getCurrencyCode());
            this.service.scheduleCalculatedBalanceFetch(o.getCurrencyPair().counter.getCurrencyCode());
        });
    }

    public Observable<Order> getOrderChanges(CurrencyPair currencyPair, Object ... args) {
        return this.getOrderChanges().filter(o -> currencyPair.equals((Object)o.getCurrencyPair()));
    }

    public Observable<UserTrade> getUserTrades() {
        return this.getRawAuthenticatedTrades().filter(o -> o.getId() != 0L).map(BitfinexStreamingAdapters::adaptUserTrade).doOnNext(t -> {
            this.service.scheduleCalculatedBalanceFetch(t.getCurrencyPair().base.getCurrencyCode());
            this.service.scheduleCalculatedBalanceFetch(t.getCurrencyPair().counter.getCurrencyCode());
        });
    }

    public Observable<UserTrade> getUserTrades(CurrencyPair currencyPair, Object ... args) {
        return this.getUserTrades().filter(t -> currencyPair.equals((Object)t.getCurrencyPair()));
    }

    public Observable<BitfinexWebSocketAuthOrder> getRawAuthenticatedOrders() {
        return this.withAuthenticatedService(BitfinexStreamingService::getAuthenticatedOrders);
    }

    public Observable<BitfinexWebSocketAuthPreTrade> getRawAuthenticatedPreTrades() {
        return this.withAuthenticatedService(BitfinexStreamingService::getAuthenticatedPreTrades);
    }

    public Observable<BitfinexWebSocketAuthTrade> getRawAuthenticatedTrades() {
        return this.withAuthenticatedService(BitfinexStreamingService::getAuthenticatedTrades);
    }

    private <T> Observable<T> withAuthenticatedService(Function<BitfinexStreamingService, Observable<T>> serviceConsumer) {
        if (!this.service.isAuthenticated()) {
            throw new ExchangeSecurityException("Not authenticated");
        }
        return serviceConsumer.apply(this.service);
    }
}

