/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.bitfinex;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import info.bitrich.xchangestream.bitfinex.BitfinexStreamingService;
import info.bitrich.xchangestream.bitfinex.dto.BitfinexOrderbook;
import info.bitrich.xchangestream.bitfinex.dto.BitfinexWebSocketOrderbookTransaction;
import info.bitrich.xchangestream.bitfinex.dto.BitfinexWebSocketSnapshotOrderbook;
import info.bitrich.xchangestream.bitfinex.dto.BitfinexWebSocketSnapshotTrades;
import info.bitrich.xchangestream.bitfinex.dto.BitfinexWebSocketTickerTransaction;
import info.bitrich.xchangestream.bitfinex.dto.BitfinexWebSocketTradesTransaction;
import info.bitrich.xchangestream.bitfinex.dto.BitfinexWebSocketUpdateOrderbook;
import info.bitrich.xchangestream.bitfinex.dto.BitfinexWebsocketUpdateTrade;
import info.bitrich.xchangestream.core.StreamingMarketDataService;
import info.bitrich.xchangestream.service.netty.StreamingObjectMapperHelper;
import io.reactivex.Observable;
import java.util.HashMap;
import java.util.Map;
import org.knowm.xchange.bitfinex.service.BitfinexAdapters;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexDepth;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexTicker;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexTrade;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;

public class BitfinexStreamingMarketDataService
implements StreamingMarketDataService {
    private final BitfinexStreamingService service;
    private final Map<CurrencyPair, BitfinexOrderbook> orderbooks = new HashMap<CurrencyPair, BitfinexOrderbook>();

    public BitfinexStreamingMarketDataService(BitfinexStreamingService service) {
        this.service = service;
    }

    private String pairToSymbol(CurrencyPair currencyPair) {
        return currencyPair.counter == Currency.USDT ? "t" + currencyPair.base.getCurrencyCode() + "UST" : "t" + currencyPair.base.getCurrencyCode() + currencyPair.counter.getCurrencyCode();
    }

    public Observable<OrderBook> getOrderBook(CurrencyPair currencyPair, Object ... args) {
        String channelName = "book";
        String depth = args.length > 0 ? args[0].toString() : "100";
        String pair = this.pairToSymbol(currencyPair);
        ObjectMapper mapper = StreamingObjectMapperHelper.getObjectMapper();
        Observable subscribedChannel = this.service.subscribeChannel(channelName, new Object[]{pair, "P0", depth}).map(s -> {
            if (s.get(1).get(0).isArray()) {
                return (BitfinexWebSocketOrderbookTransaction)mapper.treeToValue((TreeNode)s, BitfinexWebSocketSnapshotOrderbook.class);
            }
            return (BitfinexWebSocketOrderbookTransaction)mapper.treeToValue((TreeNode)s, BitfinexWebSocketUpdateOrderbook.class);
        });
        return subscribedChannel.map(s -> {
            BitfinexOrderbook bitfinexOrderbook = s.toBitfinexOrderBook(this.orderbooks.getOrDefault(currencyPair, null));
            this.orderbooks.put(currencyPair, bitfinexOrderbook);
            return BitfinexAdapters.adaptOrderBook((BitfinexDepth)bitfinexOrderbook.toBitfinexDepth(), (CurrencyPair)currencyPair);
        });
    }

    public Observable<Ticker> getTicker(CurrencyPair currencyPair, Object ... args) {
        String channelName = "ticker";
        String pair = this.pairToSymbol(currencyPair);
        ObjectMapper mapper = StreamingObjectMapperHelper.getObjectMapper();
        Observable subscribedChannel = this.service.subscribeChannel(channelName, new Object[]{pair}).map(s -> (BitfinexWebSocketTickerTransaction)mapper.treeToValue((TreeNode)s, BitfinexWebSocketTickerTransaction.class));
        return subscribedChannel.map(s -> BitfinexAdapters.adaptTicker((BitfinexTicker)s.toBitfinexTicker(), (CurrencyPair)currencyPair));
    }

    public Observable<Trade> getTrades(CurrencyPair currencyPair, Object ... args) {
        String channelName = "trades";
        String tradeType = args.length > 0 ? args[0].toString() : "te";
        String pair = this.pairToSymbol(currencyPair);
        ObjectMapper mapper = StreamingObjectMapperHelper.getObjectMapper();
        Observable subscribedChannel = this.service.subscribeChannel(channelName, new Object[]{pair}).filter(s -> s.get(1).asText().equals(tradeType)).map(s -> {
            if (s.get(1).asText().equals("te") || s.get(1).asText().equals("tu")) {
                return (BitfinexWebSocketTradesTransaction)mapper.treeToValue((TreeNode)s, BitfinexWebsocketUpdateTrade.class);
            }
            return (BitfinexWebSocketTradesTransaction)mapper.treeToValue((TreeNode)s, BitfinexWebSocketSnapshotTrades.class);
        });
        return subscribedChannel.flatMapIterable(s -> {
            Trades adaptedTrades = BitfinexAdapters.adaptTrades((BitfinexTrade[])s.toBitfinexTrades(), (CurrencyPair)currencyPair);
            return adaptedTrades.getTrades();
        });
    }
}

