/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.simulated;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.ExchangeSecurityException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.service.BaseExchangeService;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByCurrencyPair;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderByOrderTypeParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.DefaultCancelOrderParamId;
import org.knowm.xchange.service.trade.params.DefaultTradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.orders.DefaultOpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.DefaultQueryOrderParam;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import org.knowm.xchange.service.trade.params.orders.OrderQueryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OrderQueryParams;
import org.knowm.xchange.simulated.MatchingEngine;
import org.knowm.xchange.simulated.SimulatedExchange;

public class SimulatedTradeService
extends BaseExchangeService<SimulatedExchange>
implements TradeService {
    protected SimulatedTradeService(SimulatedExchange exchange) {
        super((Exchange)exchange);
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        MatchingEngine engine = ((SimulatedExchange)this.exchange).getEngine(limitOrder.getCurrencyPair());
        ((SimulatedExchange)this.exchange).maybeThrow();
        return engine.postOrder(this.getApiKey(), (Order)limitOrder).getId();
    }

    public String placeLimitOrderUnrestricted(LimitOrder limitOrder) {
        MatchingEngine engine = ((SimulatedExchange)this.exchange).getEngine(limitOrder.getCurrencyPair());
        return engine.postOrder(this.getApiKey(), (Order)limitOrder).getId();
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        MatchingEngine engine = ((SimulatedExchange)this.exchange).getEngine(marketOrder.getCurrencyPair());
        ((SimulatedExchange)this.exchange).maybeThrow();
        return engine.postOrder(this.getApiKey(), (Order)marketOrder).getId();
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        if (params instanceof OpenOrdersParamCurrencyPair) {
            MatchingEngine engine = ((SimulatedExchange)this.exchange).getEngine(((OpenOrdersParamCurrencyPair)params).getCurrencyPair());
            ((SimulatedExchange)this.exchange).maybeThrow();
            return new OpenOrders(engine.openOrders(this.getApiKey()));
        }
        return new OpenOrders(((SimulatedExchange)this.exchange).getEngines().stream().flatMap(e -> e.openOrders(this.getApiKey()).stream()).collect(Collectors.toList()));
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        if (!(params instanceof TradeHistoryParamCurrencyPair)) {
            throw new ExchangeException("Currency pair required");
        }
        MatchingEngine engine = ((SimulatedExchange)this.exchange).getEngine(((TradeHistoryParamCurrencyPair)params).getCurrencyPair());
        ((SimulatedExchange)this.exchange).maybeThrow();
        return new UserTrades(engine.tradeHistory(this.getApiKey()), Trades.TradeSortType.SortByTimestamp);
    }

    public OpenOrdersParamCurrencyPair createOpenOrdersParams() {
        return new DefaultOpenOrdersParamCurrencyPair();
    }

    public TradeHistoryParamCurrencyPair createTradeHistoryParams() {
        return new DefaultTradeHistoryParamCurrencyPair();
    }

    private String getApiKey() {
        String apiKey = ((SimulatedExchange)this.exchange).getExchangeSpecification().getApiKey();
        if (StringUtils.isEmpty((CharSequence)apiKey)) {
            throw new ExchangeSecurityException("No API key provided");
        }
        return apiKey;
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        if (orderParams instanceof CancelOrderByCurrencyPair) {
            MatchingEngine engine2 = ((SimulatedExchange)this.exchange).getEngine(((CancelOrderByCurrencyPair)orderParams).getCurrencyPair());
            ((SimulatedExchange)this.exchange).maybeThrow();
            if (orderParams instanceof CancelOrderByIdParams && orderParams instanceof CancelOrderByOrderTypeParams) {
                String orderId = ((CancelOrderByIdParams)orderParams).getOrderId();
                Order.OrderType type = ((CancelOrderByOrderTypeParams)orderParams).getOrderType();
                engine2.cancelOrder(orderId, this.getApiKey(), type);
                return true;
            }
        } else if (orderParams instanceof DefaultCancelOrderParamId) {
            String orderId = ((CancelOrderByIdParams)orderParams).getOrderId();
            ((SimulatedExchange)this.exchange).getEngines().forEach(engine -> engine.cancelOrder(this.getApiKey(), orderId));
            return true;
        }
        throw new NotYetImplementedForExchangeException();
    }

    public Class[] getRequiredCancelOrderParamClasses() {
        return new Class[]{CancelOrderByIdParams.class, CancelOrderByCurrencyPair.class, CancelOrderByOrderTypeParams.class};
    }

    public boolean cancelOrder(String orderId) throws IOException {
        return this.cancelOrder((CancelOrderParams)new DefaultCancelOrderParamId(orderId));
    }

    public Class getRequiredOrderQueryParamClass() {
        return OrderQueryParamCurrencyPair.class;
    }

    public Collection<Order> getOrder(OrderQueryParams ... orderQueryParams) {
        return Arrays.stream(orderQueryParams).flatMap(p -> {
            if (p instanceof OrderQueryParamCurrencyPair) {
                return ((SimulatedExchange)this.exchange).getEngine(((OrderQueryParamCurrencyPair)p).getCurrencyPair()).openOrders(this.getApiKey()).stream().filter(o -> o.getId().equals(p.getOrderId()));
            }
            if (p instanceof DefaultQueryOrderParam) {
                return ((SimulatedExchange)this.exchange).getEngines().stream().flatMap(e -> e.openOrders(this.getApiKey()).stream()).filter(o -> o.getId().equals(p.getOrderId()));
            }
            throw new NotYetImplementedForExchangeException();
        }).collect(Collectors.toList());
    }

    public Collection<Order> getOrder(String ... orderIds) {
        ArrayList<Order> openOrders = new ArrayList<Order>();
        for (String orderId : orderIds) {
            openOrders.addAll(this.getOrder(new OrderQueryParams[]{new DefaultQueryOrderParam(orderId)}));
        }
        return openOrders;
    }
}

