/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.simulated;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.meta.InstrumentMetaData;
import org.knowm.xchange.exceptions.CurrencyPairNotValidException;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.ExchangeSecurityException;
import org.knowm.xchange.simulated.Account;
import org.knowm.xchange.simulated.AccountFactory;
import org.knowm.xchange.simulated.MatchingEngine;
import org.knowm.xchange.simulated.MatchingEngineFactory;
import org.knowm.xchange.simulated.SimulatedAccountService;
import org.knowm.xchange.simulated.SimulatedExchangeOperationListener;
import org.knowm.xchange.simulated.SimulatedMarketDataService;
import org.knowm.xchange.simulated.SimulatedTradeService;
import si.mazi.rescu.SynchronizedValueFactory;

public class SimulatedExchange
extends BaseExchange {
    public static final String ENGINE_FACTORY_PARAM = "MatchingEngineFactory";
    public static final String ACCOUNT_FACTORY_PARAM = "AccountFactory";
    public static final String ON_OPERATION_PARAM = "OnExchangeOperation";
    private MatchingEngineFactory engineFactory;
    private AccountFactory accountFactory;
    private SimulatedExchangeOperationListener exceptionThrower;

    public SynchronizedValueFactory<Long> getNonceFactory() {
        throw new UnsupportedOperationException("Nonce factory is not used.");
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass());
        exchangeSpecification.setExchangeName("Simulated");
        exchangeSpecification.setExchangeDescription("A simulated exchange for integration testing purposes.");
        AccountFactory accountFactory = new AccountFactory();
        exchangeSpecification.setExchangeSpecificParametersItem(ENGINE_FACTORY_PARAM, (Object)new MatchingEngineFactory(accountFactory));
        exchangeSpecification.setExchangeSpecificParametersItem(ACCOUNT_FACTORY_PARAM, (Object)accountFactory);
        exchangeSpecification.setExchangeSpecificParametersItem(ON_OPERATION_PARAM, () -> {});
        return exchangeSpecification;
    }

    protected void initServices() {
        this.engineFactory = (MatchingEngineFactory)this.exchangeSpecification.getExchangeSpecificParametersItem(ENGINE_FACTORY_PARAM);
        this.accountFactory = (AccountFactory)this.exchangeSpecification.getExchangeSpecificParametersItem(ACCOUNT_FACTORY_PARAM);
        this.exceptionThrower = (SimulatedExchangeOperationListener)this.exchangeSpecification.getExchangeSpecificParametersItem(ON_OPERATION_PARAM);
        this.tradeService = new SimulatedTradeService(this);
        this.marketDataService = new SimulatedMarketDataService(this);
        this.accountService = new SimulatedAccountService(this);
    }

    public void remoteInit() throws IOException, ExchangeException {
        if (StringUtils.isNotEmpty((CharSequence)this.exchangeSpecification.getApiKey())) {
            this.getAccount().initialize(this.getExchangeMetaData().getCurrencies().keySet());
        }
    }

    Account getAccount() {
        if (StringUtils.isEmpty((CharSequence)this.exchangeSpecification.getApiKey())) {
            throw new ExchangeSecurityException("API key required for account access");
        }
        return this.accountFactory.get(this.exchangeSpecification.getApiKey());
    }

    void maybeThrow() throws IOException {
        this.exceptionThrower.onSimulatedExchangeOperation();
    }

    Collection<MatchingEngine> getEngines() {
        return this.engineFactory.engines();
    }

    MatchingEngine getEngine(CurrencyPair currencyPair) {
        InstrumentMetaData currencyPairMetaData = (InstrumentMetaData)this.getExchangeMetaData().getInstruments().get(currencyPair);
        if (currencyPairMetaData == null) {
            throw new CurrencyPairNotValidException("Currency pair " + currencyPair + " not known", currencyPair);
        }
        return this.engineFactory.create(currencyPair, currencyPairMetaData == null ? 8 : currencyPairMetaData.getPriceScale(), currencyPairMetaData == null ? BigDecimal.ZERO : currencyPairMetaData.getMinimumAmount());
    }

    public SimulatedMarketDataService getMarketDataService() {
        return (SimulatedMarketDataService)super.getMarketDataService();
    }

    public SimulatedAccountService getAccountService() {
        return (SimulatedAccountService)super.getAccountService();
    }

    public SimulatedTradeService getTradeService() {
        return (SimulatedTradeService)super.getTradeService();
    }
}

