/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.simulated;

import java.math.BigDecimal;
import java.util.Date;
import java.util.UUID;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.instrument.Instrument;

final class BookOrder {
    private static final BigDecimal INF = BigDecimal.valueOf(Long.MAX_VALUE);
    private final String apiKey;
    private final BigDecimal originalAmount;
    private final String id;
    private final Date timestamp;
    private final BigDecimal limitPrice;
    private final Order.OrderType type;
    private volatile BigDecimal cumulativeAmount;
    private volatile BigDecimal averagePrice;
    private volatile BigDecimal fee;

    static BookOrder fromOrder(Order original, String apiKey) {
        return BookOrder.builder().apiKey(apiKey).id(UUID.randomUUID().toString()).limitPrice(original instanceof LimitOrder ? ((LimitOrder)original).getLimitPrice() : (original.getType() == Order.OrderType.ASK ? BigDecimal.ZERO : INF)).originalAmount(original.getOriginalAmount()).timestamp(new Date()).type(original.getType()).build();
    }

    BigDecimal getRemainingAmount() {
        return this.originalAmount.subtract(this.cumulativeAmount);
    }

    boolean isDone() {
        return this.originalAmount.compareTo(this.cumulativeAmount) == 0;
    }

    boolean matches(BookOrder takerOrder) {
        return this.type == Order.OrderType.ASK ? this.limitPrice.compareTo(takerOrder.getLimitPrice()) <= 0 : this.limitPrice.compareTo(takerOrder.getLimitPrice()) >= 0;
    }

    LimitOrder toOrder(CurrencyPair currencyPair) {
        return new LimitOrder.Builder(this.type, (Instrument)currencyPair).id(this.id).averagePrice(this.averagePrice).cumulativeAmount(this.cumulativeAmount).fee(this.fee).limitPrice(this.limitPrice).orderStatus(this.cumulativeAmount.compareTo(BigDecimal.ZERO) == 0 ? Order.OrderStatus.NEW : (this.cumulativeAmount.compareTo(this.originalAmount) == 0 ? Order.OrderStatus.FILLED : Order.OrderStatus.PARTIALLY_FILLED)).originalAmount(this.originalAmount).timestamp(this.timestamp).build();
    }

    private static BigDecimal $default$cumulativeAmount() {
        return BigDecimal.ZERO;
    }

    private static BigDecimal $default$fee() {
        return BigDecimal.ZERO;
    }

    BookOrder(String apiKey, BigDecimal originalAmount, String id, Date timestamp, BigDecimal limitPrice, Order.OrderType type, BigDecimal cumulativeAmount, BigDecimal averagePrice, BigDecimal fee) {
        this.apiKey = apiKey;
        this.originalAmount = originalAmount;
        this.id = id;
        this.timestamp = timestamp;
        this.limitPrice = limitPrice;
        this.type = type;
        this.cumulativeAmount = cumulativeAmount;
        this.averagePrice = averagePrice;
        this.fee = fee;
    }

    public static BookOrderBuilder builder() {
        return new BookOrderBuilder();
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public BigDecimal getOriginalAmount() {
        return this.originalAmount;
    }

    public String getId() {
        return this.id;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public BigDecimal getLimitPrice() {
        return this.limitPrice;
    }

    public Order.OrderType getType() {
        return this.type;
    }

    public BigDecimal getCumulativeAmount() {
        return this.cumulativeAmount;
    }

    public BigDecimal getAveragePrice() {
        return this.averagePrice;
    }

    public BigDecimal getFee() {
        return this.fee;
    }

    public void setCumulativeAmount(BigDecimal cumulativeAmount) {
        this.cumulativeAmount = cumulativeAmount;
    }

    public void setAveragePrice(BigDecimal averagePrice) {
        this.averagePrice = averagePrice;
    }

    public void setFee(BigDecimal fee) {
        this.fee = fee;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BookOrder)) {
            return false;
        }
        BookOrder other = (BookOrder)o;
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        BigDecimal this$originalAmount = this.getOriginalAmount();
        BigDecimal other$originalAmount = other.getOriginalAmount();
        if (this$originalAmount == null ? other$originalAmount != null : !((Object)this$originalAmount).equals(other$originalAmount)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Date this$timestamp = this.getTimestamp();
        Date other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        BigDecimal this$limitPrice = this.getLimitPrice();
        BigDecimal other$limitPrice = other.getLimitPrice();
        if (this$limitPrice == null ? other$limitPrice != null : !((Object)this$limitPrice).equals(other$limitPrice)) {
            return false;
        }
        Order.OrderType this$type = this.getType();
        Order.OrderType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        BigDecimal this$cumulativeAmount = this.getCumulativeAmount();
        BigDecimal other$cumulativeAmount = other.getCumulativeAmount();
        if (this$cumulativeAmount == null ? other$cumulativeAmount != null : !((Object)this$cumulativeAmount).equals(other$cumulativeAmount)) {
            return false;
        }
        BigDecimal this$averagePrice = this.getAveragePrice();
        BigDecimal other$averagePrice = other.getAveragePrice();
        if (this$averagePrice == null ? other$averagePrice != null : !((Object)this$averagePrice).equals(other$averagePrice)) {
            return false;
        }
        BigDecimal this$fee = this.getFee();
        BigDecimal other$fee = other.getFee();
        return !(this$fee == null ? other$fee != null : !((Object)this$fee).equals(other$fee));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        BigDecimal $originalAmount = this.getOriginalAmount();
        result = result * 59 + ($originalAmount == null ? 43 : ((Object)$originalAmount).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Date $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        BigDecimal $limitPrice = this.getLimitPrice();
        result = result * 59 + ($limitPrice == null ? 43 : ((Object)$limitPrice).hashCode());
        Order.OrderType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        BigDecimal $cumulativeAmount = this.getCumulativeAmount();
        result = result * 59 + ($cumulativeAmount == null ? 43 : ((Object)$cumulativeAmount).hashCode());
        BigDecimal $averagePrice = this.getAveragePrice();
        result = result * 59 + ($averagePrice == null ? 43 : ((Object)$averagePrice).hashCode());
        BigDecimal $fee = this.getFee();
        result = result * 59 + ($fee == null ? 43 : ((Object)$fee).hashCode());
        return result;
    }

    public String toString() {
        return "BookOrder(apiKey=" + this.getApiKey() + ", originalAmount=" + this.getOriginalAmount() + ", id=" + this.getId() + ", timestamp=" + this.getTimestamp() + ", limitPrice=" + this.getLimitPrice() + ", type=" + this.getType() + ", cumulativeAmount=" + this.getCumulativeAmount() + ", averagePrice=" + this.getAveragePrice() + ", fee=" + this.getFee() + ")";
    }

    public static class BookOrderBuilder {
        private String apiKey;
        private BigDecimal originalAmount;
        private String id;
        private Date timestamp;
        private BigDecimal limitPrice;
        private Order.OrderType type;
        private boolean cumulativeAmount$set;
        private BigDecimal cumulativeAmount$value;
        private BigDecimal averagePrice;
        private boolean fee$set;
        private BigDecimal fee$value;

        BookOrderBuilder() {
        }

        public BookOrderBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public BookOrderBuilder originalAmount(BigDecimal originalAmount) {
            this.originalAmount = originalAmount;
            return this;
        }

        public BookOrderBuilder id(String id) {
            this.id = id;
            return this;
        }

        public BookOrderBuilder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public BookOrderBuilder limitPrice(BigDecimal limitPrice) {
            this.limitPrice = limitPrice;
            return this;
        }

        public BookOrderBuilder type(Order.OrderType type) {
            this.type = type;
            return this;
        }

        public BookOrderBuilder cumulativeAmount(BigDecimal cumulativeAmount) {
            this.cumulativeAmount$value = cumulativeAmount;
            this.cumulativeAmount$set = true;
            return this;
        }

        public BookOrderBuilder averagePrice(BigDecimal averagePrice) {
            this.averagePrice = averagePrice;
            return this;
        }

        public BookOrderBuilder fee(BigDecimal fee) {
            this.fee$value = fee;
            this.fee$set = true;
            return this;
        }

        public BookOrder build() {
            BigDecimal cumulativeAmount$value = this.cumulativeAmount$value;
            if (!this.cumulativeAmount$set) {
                cumulativeAmount$value = BookOrder.$default$cumulativeAmount();
            }
            BigDecimal fee$value = this.fee$value;
            if (!this.fee$set) {
                fee$value = BookOrder.$default$fee();
            }
            return new BookOrder(this.apiKey, this.originalAmount, this.id, this.timestamp, this.limitPrice, this.type, cumulativeAmount$value, this.averagePrice, fee$value);
        }

        public String toString() {
            return "BookOrder.BookOrderBuilder(apiKey=" + this.apiKey + ", originalAmount=" + this.originalAmount + ", id=" + this.id + ", timestamp=" + this.timestamp + ", limitPrice=" + this.limitPrice + ", type=" + this.type + ", cumulativeAmount$value=" + this.cumulativeAmount$value + ", averagePrice=" + this.averagePrice + ", fee$value=" + this.fee$value + ")";
        }
    }
}

