/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.quoine.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.quoine.QuoineAuthenticated;
import org.knowm.xchange.quoine.QuoineExchange;
import org.knowm.xchange.quoine.service.QuoineSignatureDigest;
import org.knowm.xchange.service.BaseExchangeService;
import org.knowm.xchange.service.BaseService;
import si.mazi.rescu.HttpStatusIOException;
import si.mazi.rescu.SynchronizedValueFactory;

public class QuoineBaseService
extends BaseExchangeService
implements BaseService {
    protected static final int QUOINE_API_VERSION = 2;
    protected final QuoineSignatureDigest signatureCreator;
    protected final String contentType = "application/json";
    protected final String tokenID;
    protected final String secret;
    protected QuoineAuthenticated quoine;

    public QuoineBaseService(Exchange exchange) {
        super(exchange);
        this.quoine = (QuoineAuthenticated)ExchangeRestProxyBuilder.forInterface(QuoineAuthenticated.class, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
        this.tokenID = exchange.getExchangeSpecification().getApiKey();
        this.secret = exchange.getExchangeSpecification().getSecretKey();
        this.signatureCreator = this.tokenID != null && this.secret != null ? new QuoineSignatureDigest(this.tokenID, this.secret, (SynchronizedValueFactory<Long>)exchange.getNonceFactory()) : null;
    }

    protected RuntimeException handleHttpError(HttpStatusIOException exception) throws IOException {
        throw new ExchangeException(exception.getHttpBody(), (Throwable)exception);
    }

    protected Integer productId(CurrencyPair currencyPair) {
        return ((QuoineExchange)this.exchange).getProductId(currencyPair);
    }
}

