/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.quoine.dto.trade;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import org.knowm.xchange.quoine.dto.trade.QuoineNewOrderRequest;

public class QuoineNewMarginOrderRequest
extends QuoineNewOrderRequest {
    @JsonProperty(value="leverage_level")
    private final int leverageLevel;
    @JsonProperty(value="funding_currency")
    private final String fundingCurrency;
    @JsonProperty(value="order_direction")
    private final String orderDirection;

    public QuoineNewMarginOrderRequest(String orderType, int productCode, String side, BigDecimal quantity, BigDecimal price, int leverageLevel, String fundingCurrency) {
        super(orderType, productCode, side, quantity, price);
        this.leverageLevel = leverageLevel;
        this.fundingCurrency = fundingCurrency;
        this.orderDirection = "netout";
    }

    public int getLeverageLevel() {
        return this.leverageLevel;
    }

    public String getFundingCurrency() {
        return this.fundingCurrency;
    }

    public String getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("QuoineNewMarginOrderRequest [leverageLevel=");
        builder.append(this.leverageLevel);
        builder.append(", getFundingCurrency()=");
        builder.append(this.fundingCurrency);
        builder.append(", getOrderType()=");
        builder.append(this.getOrderType());
        builder.append(", getProductId()=");
        builder.append(this.getProductId());
        builder.append(", getSide()=");
        builder.append(this.getSide());
        builder.append(", getQuantity()=");
        builder.append(this.getQuantity());
        builder.append(", getPrice()=");
        builder.append(this.getPrice());
        builder.append(", toString()=");
        builder.append(super.toString());
        builder.append(", getClass()=");
        builder.append(this.getClass());
        builder.append(", hashCode()=");
        builder.append(this.hashCode());
        builder.append("]");
        return builder.toString();
    }
}

