/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.quoine;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.quoine.dto.account.BitcoinAccount;
import org.knowm.xchange.quoine.dto.account.FiatAccount;
import org.knowm.xchange.quoine.dto.account.QuoineAccountInfo;
import org.knowm.xchange.quoine.dto.account.QuoineTradingAccountInfo;
import org.knowm.xchange.quoine.dto.marketdata.QuoineOrderBook;
import org.knowm.xchange.quoine.dto.marketdata.QuoineProduct;
import org.knowm.xchange.quoine.dto.trade.Model;
import org.knowm.xchange.quoine.dto.trade.QuoineExecution;
import org.knowm.xchange.quoine.dto.trade.QuoineOrdersList;
import org.knowm.xchange.quoine.dto.trade.QuoineTransaction;
import org.knowm.xchange.utils.DateUtils;

public class QuoineAdapters {
    public static Ticker adaptTicker(QuoineProduct quoineTicker, CurrencyPair currencyPair) {
        Ticker.Builder builder = new Ticker.Builder();
        builder.ask(quoineTicker.getMarketAsk());
        builder.bid(quoineTicker.getMarketBid());
        builder.last(quoineTicker.getLastTradedPrice());
        builder.volume(quoineTicker.getVolume24h());
        builder.currencyPair(currencyPair);
        return builder.build();
    }

    public static OrderBook adaptOrderBook(QuoineOrderBook quoineOrderBook, CurrencyPair currencyPair) {
        List<LimitOrder> asks = QuoineAdapters.createOrders(currencyPair, Order.OrderType.ASK, quoineOrderBook.getSellPriceLevels());
        List<LimitOrder> bids = QuoineAdapters.createOrders(currencyPair, Order.OrderType.BID, quoineOrderBook.getBuyPriceLevels());
        return new OrderBook(null, asks, bids);
    }

    public static List<LimitOrder> createOrders(CurrencyPair currencyPair, Order.OrderType orderType, List<BigDecimal[]> orders) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (BigDecimal[] ask : orders) {
            QuoineAdapters.checkArgument(ask.length == 2, "Expected a pair (price, amount) but got {0} elements.", ask.length);
            limitOrders.add(QuoineAdapters.createOrder(currencyPair, ask, orderType));
        }
        return limitOrders;
    }

    public static LimitOrder createOrder(CurrencyPair currencyPair, BigDecimal[] priceAndAmount, Order.OrderType orderType) {
        return new LimitOrder(orderType, priceAndAmount[1], (Instrument)currencyPair, "", null, priceAndAmount[0]);
    }

    public static void checkArgument(boolean argument, String msgPattern, Object ... msgArgs) {
        if (!argument) {
            throw new IllegalArgumentException(MessageFormat.format(msgPattern, msgArgs));
        }
    }

    public static Wallet adaptTradingWallet(QuoineTradingAccountInfo[] quoineWallet) {
        ArrayList<Balance> balances = new ArrayList<Balance>(quoineWallet.length);
        for (int i = 0; i < quoineWallet.length; ++i) {
            QuoineTradingAccountInfo info = quoineWallet[i];
            balances.add(new Balance(Currency.getInstance((String)info.getFundingCurrency()), info.getFreeMargin()));
        }
        return Wallet.Builder.from(balances).build();
    }

    public static Wallet adaptFiatAccountWallet(FiatAccount[] fiatAccounts) {
        ArrayList<Balance> balances = new ArrayList<Balance>();
        for (FiatAccount fiatAccount : fiatAccounts) {
            Balance fiatBalance = new Balance(Currency.getInstance((String)fiatAccount.getCurrency()), fiatAccount.getBalance(), fiatAccount.getBalance());
            balances.add(fiatBalance);
        }
        return Wallet.Builder.from(balances).build();
    }

    public static Wallet adaptWallet(QuoineAccountInfo quoineWallet) {
        ArrayList<Balance> balances = new ArrayList<Balance>();
        Balance btcBalance = new Balance(Currency.getInstance((String)quoineWallet.getBitcoinAccount().getCurrency()), quoineWallet.getBitcoinAccount().getBalance(), quoineWallet.getBitcoinAccount().getFreeBalance());
        balances.add(btcBalance);
        for (FiatAccount fiatAccount : quoineWallet.getFiatAccounts()) {
            Balance fiatBalance = new Balance(Currency.getInstance((String)fiatAccount.getCurrency()), fiatAccount.getBalance(), fiatAccount.getBalance());
            balances.add(fiatBalance);
        }
        return Wallet.Builder.from(balances).build();
    }

    public static OpenOrders adapteOpenOrders(QuoineOrdersList quoineOrdersList) {
        ArrayList<LimitOrder> openOrders = new ArrayList<LimitOrder>();
        for (Model model : quoineOrdersList.getModels()) {
            if (!model.getStatus().equals("live")) continue;
            String baseSymbol = model.getCurrencyPairCode().replace(model.getFundingCurrency(), "");
            String counterSymbol = model.getFundingCurrency();
            CurrencyPair currencyPair = new CurrencyPair(baseSymbol, counterSymbol);
            Order.OrderType orderType = model.getSide().equals("sell") ? Order.OrderType.ASK : Order.OrderType.BID;
            Date timestamp = new Date(model.getCreatedAt().longValue() * 1000L);
            LimitOrder limitOrder = new LimitOrder(orderType, model.getQuantity(), model.getFilledQuantity(), (Instrument)currencyPair, model.getId(), timestamp, model.getPrice());
            openOrders.add(limitOrder);
        }
        return new OpenOrders(openOrders);
    }

    public static Wallet adapt(FiatAccount[] fiatBalances, BitcoinAccount[] cryptoBalances) {
        ArrayList<Balance> balanceList = new ArrayList<Balance>();
        for (FiatAccount nativeBalance : fiatBalances) {
            balanceList.add(new Balance(Currency.getInstance((String)nativeBalance.getCurrency()), nativeBalance.getBalance()));
        }
        for (BitcoinAccount cryptoBalance : cryptoBalances) {
            balanceList.add(new Balance(Currency.getInstance((String)cryptoBalance.getCurrency()), cryptoBalance.getBalance()));
        }
        return Wallet.Builder.from(balanceList).build();
    }

    public static List<UserTrade> adapt(List<QuoineExecution> executions, CurrencyPair currencyPair) {
        ArrayList<UserTrade> res = new ArrayList<UserTrade>();
        for (QuoineExecution execution : executions) {
            res.add(UserTrade.builder().type(execution.mySide.equals("sell") ? Order.OrderType.ASK : Order.OrderType.BID).originalAmount(execution.quantity).currencyPair(currencyPair).price(execution.price).timestamp(DateUtils.fromUnixTime((long)execution.createdAt)).id(execution.id).orderId(execution.orderId).build());
        }
        return res;
    }

    public static String toPairString(CurrencyPair currencyPair) {
        return currencyPair.base.getCurrencyCode() + currencyPair.counter.getCurrencyCode();
    }

    public static FundingRecord adaptFunding(Currency currency, QuoineTransaction transaction, FundingRecord.Type deposit) {
        BigDecimal fee = null;
        if (transaction.exchange_fee != null) {
            fee = transaction.exchange_fee;
        }
        if (transaction.network_fee != null) {
            fee = fee == null ? transaction.network_fee : fee.add(transaction.network_fee);
        }
        return new FundingRecord(null, DateUtils.fromUnixTime((long)transaction.createdAt), currency, transaction.gross_amount, transaction.id, transaction.transaction_hash, deposit, FundingRecord.Status.COMPLETE, null, fee, transaction.notes);
    }
}

