/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.poloniex.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.poloniex.PoloniexAdapters;
import org.knowm.xchange.poloniex.PoloniexErrorAdapter;
import org.knowm.xchange.poloniex.PoloniexUtils;
import org.knowm.xchange.poloniex.dto.PoloniexException;
import org.knowm.xchange.poloniex.dto.trade.PoloniexLimitOrder;
import org.knowm.xchange.poloniex.dto.trade.PoloniexOpenOrder;
import org.knowm.xchange.poloniex.dto.trade.PoloniexTradeResponse;
import org.knowm.xchange.poloniex.dto.trade.PoloniexUserTrade;
import org.knowm.xchange.poloniex.service.PoloniexMarketDataService;
import org.knowm.xchange.poloniex.service.PoloniexTradeServiceRaw;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParamLimit;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsAll;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.orders.DefaultOpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import org.knowm.xchange.service.trade.params.orders.OrderQueryParams;
import org.knowm.xchange.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoloniexTradeService
extends PoloniexTradeServiceRaw
implements TradeService {
    private static final Logger LOG = LoggerFactory.getLogger(PoloniexTradeService.class);
    private PoloniexMarketDataService poloniexMarketDataService;

    public PoloniexTradeService(Exchange exchange, PoloniexMarketDataService poloniexMarketDataService) {
        super(exchange);
        this.poloniexMarketDataService = poloniexMarketDataService;
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders(this.createOpenOrdersParams());
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws ExchangeException, IOException {
        try {
            Map<String, PoloniexOpenOrder[]> poloniexOpenOrders;
            CurrencyPair currencyPair = null;
            if (params instanceof OpenOrdersParamCurrencyPair) {
                currencyPair = ((OpenOrdersParamCurrencyPair)params).getCurrencyPair();
            }
            if (currencyPair == null) {
                poloniexOpenOrders = this.returnOpenOrders();
            } else {
                PoloniexOpenOrder[] cpOpenOrders = this.returnOpenOrders(currencyPair);
                poloniexOpenOrders = new HashMap<String, PoloniexOpenOrder[]>(1);
                poloniexOpenOrders.put(PoloniexUtils.toPairString(currencyPair), cpOpenOrders);
            }
            return PoloniexAdapters.adaptPoloniexOpenOrders(poloniexOpenOrders);
        }
        catch (PoloniexException e) {
            throw PoloniexErrorAdapter.adapt(e);
        }
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        try {
            PoloniexTradeResponse response = limitOrder.getType() == Order.OrderType.BID || limitOrder.getType() == Order.OrderType.EXIT_ASK ? this.buy(limitOrder) : this.sell(limitOrder);
            if (limitOrder instanceof PoloniexLimitOrder) {
                PoloniexLimitOrder raw = (PoloniexLimitOrder)limitOrder;
                raw.setResponse(response);
            }
            return response.getOrderNumber().toString();
        }
        catch (PoloniexException e) {
            throw PoloniexErrorAdapter.adapt(e);
        }
    }

    public boolean cancelOrder(String orderId) throws IOException {
        try {
            return this.cancel(orderId);
        }
        catch (PoloniexException e) {
            throw PoloniexErrorAdapter.adapt(e);
        }
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        try {
            if (orderParams instanceof CancelOrderByIdParams) {
                return this.cancelOrder(((CancelOrderByIdParams)orderParams).getOrderId());
            }
            return false;
        }
        catch (PoloniexException e) {
            throw PoloniexErrorAdapter.adapt(e);
        }
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        try {
            CurrencyPair currencyPair = null;
            Date startTime = null;
            Date endTime = null;
            if (params instanceof TradeHistoryParamCurrencyPair) {
                currencyPair = ((TradeHistoryParamCurrencyPair)params).getCurrencyPair();
            }
            if (params instanceof TradeHistoryParamsTimeSpan) {
                startTime = ((TradeHistoryParamsTimeSpan)params).getStartTime();
                endTime = ((TradeHistoryParamsTimeSpan)params).getEndTime();
            }
            Integer limit = 500;
            if (params instanceof TradeHistoryParamLimit) {
                TradeHistoryParamLimit tradeHistoryParamLimit = (TradeHistoryParamLimit)params;
                limit = tradeHistoryParamLimit.getLimit();
            }
            return this.getTradeHistory(currencyPair, DateUtils.toUnixTimeNullSafe((Date)startTime), DateUtils.toUnixTimeNullSafe((Date)endTime), limit);
        }
        catch (PoloniexException e) {
            throw PoloniexErrorAdapter.adapt(e);
        }
    }

    public BigDecimal getMakerFee() throws IOException {
        try {
            String value = this.getFeeInfo().get("makerFee");
            return new BigDecimal(value);
        }
        catch (PoloniexException e) {
            throw PoloniexErrorAdapter.adapt(e);
        }
    }

    public BigDecimal getTakerFee() throws IOException {
        try {
            String value = this.getFeeInfo().get("takerFee");
            return new BigDecimal(value);
        }
        catch (PoloniexException e) {
            throw PoloniexErrorAdapter.adapt(e);
        }
    }

    private UserTrades getTradeHistory(CurrencyPair currencyPair, Long startTime, Long endTime, Integer limit) throws IOException {
        try {
            ArrayList<UserTrade> trades = new ArrayList<UserTrade>();
            if (currencyPair == null) {
                HashMap<String, PoloniexUserTrade[]> poloniexUserTrades = this.returnTradeHistory(startTime, endTime, limit);
                if (poloniexUserTrades != null) {
                    for (Map.Entry<String, PoloniexUserTrade[]> mapEntry : poloniexUserTrades.entrySet()) {
                        currencyPair = PoloniexUtils.toCurrencyPair(mapEntry.getKey());
                        for (PoloniexUserTrade poloniexUserTrade : mapEntry.getValue()) {
                            trades.add(PoloniexAdapters.adaptPoloniexUserTrade(poloniexUserTrade, currencyPair));
                        }
                    }
                }
            } else {
                PoloniexUserTrade[] poloniexUserTrades = this.returnTradeHistory(currencyPair, startTime, endTime, limit);
                if (poloniexUserTrades != null) {
                    for (PoloniexUserTrade poloniexUserTrade : poloniexUserTrades) {
                        trades.add(PoloniexAdapters.adaptPoloniexUserTrade(poloniexUserTrade, currencyPair));
                    }
                }
            }
            return new UserTrades(trades, Trades.TradeSortType.SortByTimestamp);
        }
        catch (PoloniexException e) {
            throw PoloniexErrorAdapter.adapt(e);
        }
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new PoloniexTradeHistoryParams();
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return new DefaultOpenOrdersParamCurrencyPair();
    }

    public Collection<Order> getOrderImpl(String ... orderIds) throws IOException {
        List<String> orderIdList = Arrays.asList(orderIds);
        OpenOrders openOrders = this.getOpenOrders();
        List<Order> returnValue = openOrders.getOpenOrders().stream().filter(f -> orderIdList.contains(f.getId())).collect(Collectors.toList());
        returnValue.addAll(orderIdList.stream().filter(f -> returnValue.stream().noneMatch(a -> a.getId().equals(f))).map(f -> {
            try {
                return PoloniexAdapters.adaptUserTradesToOrderStatus(f, this.returnOrderTrades((String)f));
            }
            catch (IOException e) {
                LOG.error("Unable to find status for Poloniex order id: " + f, (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()));
        return returnValue;
    }

    public Collection<Order> getOrder(OrderQueryParams ... orderQueryParams) throws IOException {
        return this.getOrderImpl(TradeService.toOrderIds((OrderQueryParams[])orderQueryParams));
    }

    public final UserTrades getOrderTrades(Order order) throws IOException {
        return this.getOrderTrades(order.getId(), order.getCurrencyPair());
    }

    public UserTrades getOrderTrades(String orderId, CurrencyPair currencyPair) throws IOException {
        try {
            ArrayList<UserTrade> trades = new ArrayList<UserTrade>();
            PoloniexUserTrade[] poloniexUserTrades = this.returnOrderTrades(orderId);
            if (poloniexUserTrades != null) {
                for (PoloniexUserTrade poloniexUserTrade : poloniexUserTrades) {
                    poloniexUserTrade.setOrderNumber(orderId);
                    trades.add(PoloniexAdapters.adaptPoloniexUserTrade(poloniexUserTrade, currencyPair));
                }
            }
            return new UserTrades(trades, Trades.TradeSortType.SortByTimestamp);
        }
        catch (PoloniexException e) {
            throw PoloniexErrorAdapter.adapt(e);
        }
    }

    public static class PoloniexTradeHistoryParams
    implements TradeHistoryParamCurrencyPair,
    TradeHistoryParamsTimeSpan {
        private final TradeHistoryParamsAll all = new TradeHistoryParamsAll();

        public CurrencyPair getCurrencyPair() {
            return this.all.getCurrencyPair();
        }

        public void setCurrencyPair(CurrencyPair value) {
            this.all.setCurrencyPair(value);
        }

        public Date getStartTime() {
            return this.all.getStartTime();
        }

        public void setStartTime(Date value) {
            this.all.setStartTime(value);
        }

        public Date getEndTime() {
            return this.all.getEndTime();
        }

        public void setEndTime(Date value) {
            this.all.setEndTime(value);
        }
    }
}

