/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.poloniex.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.poloniex.PoloniexErrorAdapter;
import org.knowm.xchange.poloniex.PoloniexUtils;
import org.knowm.xchange.poloniex.dto.PoloniexException;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexChartData;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexCurrencyInfo;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexDepth;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexMarketData;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexPublicTrade;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexTicker;
import org.knowm.xchange.poloniex.service.PoloniexBaseService;
import org.knowm.xchange.poloniex.service.PoloniexChartDataPeriodType;

public class PoloniexMarketDataServiceRaw
extends PoloniexBaseService {
    private final long cache_delay = 1000L;
    private HashMap<String, PoloniexMarketData> TickermarketData;
    private long next_refresh = System.currentTimeMillis() + 1000L;

    public PoloniexMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public Map<String, PoloniexCurrencyInfo> getPoloniexCurrencyInfo() throws IOException {
        String command = "returnCurrencies";
        return this.poloniex.getCurrencyInfo(command);
    }

    public Map<String, PoloniexMarketData> getAllPoloniexTickers() throws IOException {
        String command = "returnTicker";
        return this.poloniex.getTicker(command);
    }

    public PoloniexTicker getPoloniexTicker(CurrencyPair currencyPair) throws IOException {
        PoloniexMarketData data;
        String command = "returnTicker";
        String pairString = PoloniexUtils.toPairString(currencyPair);
        long now = System.currentTimeMillis();
        if (this.TickermarketData == null || this.next_refresh < now) {
            try {
                this.TickermarketData = this.poloniex.getTicker(command);
            }
            catch (PoloniexException e) {
                throw PoloniexErrorAdapter.adapt(e);
            }
            finally {
                this.next_refresh = now + 1000L;
            }
        }
        if ((data = this.TickermarketData.get(pairString)) == null) {
            return null;
        }
        return new PoloniexTicker(data, currencyPair);
    }

    public PoloniexDepth getPoloniexDepth(CurrencyPair currencyPair) throws IOException {
        String command = "returnOrderBook";
        String pairString = PoloniexUtils.toPairString(currencyPair);
        return this.poloniex.getOrderBook(command, pairString);
    }

    public PoloniexDepth getPoloniexDepth(CurrencyPair currencyPair, int depth) throws IOException {
        String command = "returnOrderBook";
        String pairString = PoloniexUtils.toPairString(currencyPair);
        return this.poloniex.getOrderBook(command, pairString, depth);
    }

    public Map<String, PoloniexDepth> getAllPoloniexDepths() throws IOException {
        String command = "returnOrderBook";
        return this.poloniex.getAllOrderBooks(command, "all", null);
    }

    public Map<String, PoloniexDepth> getAllPoloniexDepths(int depth) throws IOException {
        String command = "returnOrderBook";
        return this.poloniex.getAllOrderBooks(command, "all", depth);
    }

    public PoloniexPublicTrade[] getPoloniexPublicTrades(CurrencyPair currencyPair) throws IOException {
        String command = "returnTradeHistory";
        String pairString = PoloniexUtils.toPairString(currencyPair);
        return this.poloniex.getTrades(command, pairString, null, null);
    }

    public PoloniexPublicTrade[] getPoloniexPublicTrades(CurrencyPair currencyPair, Long startTime, Long endTime) throws IOException {
        String command = "returnTradeHistory";
        String pairString = PoloniexUtils.toPairString(currencyPair);
        return this.poloniex.getTrades(command, pairString, startTime, endTime);
    }

    public PoloniexChartData[] getPoloniexChartData(CurrencyPair currencyPair, Long startTime, Long endTime, PoloniexChartDataPeriodType period) throws IOException {
        String command = "returnChartData";
        String pairString = PoloniexUtils.toPairString(currencyPair);
        return this.poloniex.getChartData(command, pairString, startTime, endTime, period.getPeriodInSecs());
    }
}

