/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.poloniex.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.client.ClientConfigCustomizer;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.poloniex.Poloniex;
import org.knowm.xchange.poloniex.PoloniexAuthenticated;
import org.knowm.xchange.poloniex.service.PoloniexDigest;
import org.knowm.xchange.service.BaseExchangeService;
import org.knowm.xchange.service.BaseService;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.serialization.jackson.DefaultJacksonObjectMapperFactory;
import si.mazi.rescu.serialization.jackson.JacksonObjectMapperFactory;

public class PoloniexBaseService
extends BaseExchangeService
implements BaseService {
    protected final String apiKey;
    protected final PoloniexAuthenticated poloniexAuthenticated;
    protected final ParamsDigest signatureCreator;
    protected final Poloniex poloniex;

    public PoloniexBaseService(Exchange exchange) {
        super(exchange);
        ClientConfigCustomizer clientConfigCustomizer = rescuConfig -> rescuConfig.setJacksonObjectMapperFactory((JacksonObjectMapperFactory)new DefaultJacksonObjectMapperFactory(){

            public void configureObjectMapper(ObjectMapper objectMapper) {
                super.configureObjectMapper(objectMapper);
                objectMapper.configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true);
            }
        });
        this.poloniexAuthenticated = (PoloniexAuthenticated)ExchangeRestProxyBuilder.forInterface(PoloniexAuthenticated.class, (ExchangeSpecification)exchange.getExchangeSpecification()).clientConfigCustomizer(clientConfigCustomizer).build();
        this.apiKey = exchange.getExchangeSpecification().getApiKey();
        this.signatureCreator = PoloniexDigest.createInstance(exchange.getExchangeSpecification().getSecretKey());
        this.poloniex = (Poloniex)ExchangeRestProxyBuilder.forInterface(Poloniex.class, (ExchangeSpecification)exchange.getExchangeSpecification()).clientConfigCustomizer(clientConfigCustomizer).build();
    }
}

