/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.poloniex.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.poloniex.dto.PoloniexException;
import org.knowm.xchange.poloniex.dto.account.PoloniexBalance;
import org.knowm.xchange.poloniex.dto.account.PoloniexLoan;
import org.knowm.xchange.poloniex.dto.account.PoloniexWallet;
import org.knowm.xchange.poloniex.dto.trade.PoloniexDepositsWithdrawalsResponse;
import org.knowm.xchange.poloniex.dto.trade.PoloniexGenerateNewAddressResponse;
import org.knowm.xchange.poloniex.service.PoloniexBaseService;
import org.knowm.xchange.utils.DateUtils;
import si.mazi.rescu.SynchronizedValueFactory;

public class PoloniexAccountServiceRaw
extends PoloniexBaseService {
    public PoloniexAccountServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public HashMap<String, PoloniexBalance> getExchangeWallet() throws IOException {
        return this.poloniexAuthenticated.returnCompleteBalances(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), null);
    }

    public HashMap<String, PoloniexBalance> getWallets() throws IOException {
        return this.poloniexAuthenticated.returnCompleteBalances(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), "all");
    }

    public HashMap<String, PoloniexLoan[]> getLoanInfo() throws IOException {
        return this.poloniexAuthenticated.returnActiveLoans(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
    }

    public HashMap<String, String> getDepositAddresses() throws IOException {
        HashMap<String, String> response = this.poloniexAuthenticated.returnDepositAddresses(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        if (response.containsKey("error")) {
            throw new PoloniexException(response.get("error"));
        }
        return response;
    }

    public String getDepositAddress(String currency) throws IOException {
        HashMap<String, String> response = this.poloniexAuthenticated.returnDepositAddresses(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        if (response.containsKey("error")) {
            throw new PoloniexException(response.get("error"));
        }
        if (response.containsKey(currency)) {
            return response.get(currency);
        }
        PoloniexGenerateNewAddressResponse newAddressResponse = this.poloniexAuthenticated.generateNewAddress(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currency);
        if (newAddressResponse.success()) {
            return newAddressResponse.getAddress();
        }
        throw new PoloniexException("Failed to get Poloniex deposit address for " + currency);
    }

    public String withdraw(Currency currency, BigDecimal amount, String address, @Nullable String paymentId) throws IOException {
        return this.poloniexAuthenticated.withdraw(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currency.getCurrencyCode(), amount, address, paymentId).getResponse();
    }

    public PoloniexDepositsWithdrawalsResponse returnDepositsWithdrawals(Date start, Date end) throws IOException {
        return this.poloniexAuthenticated.returnDepositsWithdrawals(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), DateUtils.toUnixTimeNullSafe((Date)start), DateUtils.toUnixTimeNullSafe((Date)end));
    }

    public String transfer(Currency currency, BigDecimal amount, PoloniexWallet fromWallet, PoloniexWallet toWallet) throws IOException {
        return this.poloniexAuthenticated.transferBalance(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currency.getCurrencyCode(), amount, fromWallet.name().toLowerCase(), toWallet.name().toLowerCase()).getMessage();
    }
}

