/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.poloniex.dto.trade;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Map;

public class PoloniexAccountBalance {
    private final Map<String, BigDecimal> exchange;
    private final Map<String, BigDecimal> margin;
    private final Map<String, BigDecimal> lending;

    public PoloniexAccountBalance(@JsonProperty(value="exchange") Map<String, BigDecimal> exchange, @JsonProperty(value="margin") Map<String, BigDecimal> margin, @JsonProperty(value="lending") Map<String, BigDecimal> lending) {
        this.exchange = exchange;
        this.margin = margin;
        this.lending = lending;
    }

    public Map<String, BigDecimal> getExchangeBalance() {
        return this.exchange != null ? Collections.unmodifiableMap(this.exchange) : Collections.emptyMap();
    }

    public Map<String, BigDecimal> getMarginBalance() {
        return this.margin != null ? Collections.unmodifiableMap(this.margin) : Collections.emptyMap();
    }

    public Map<String, BigDecimal> getLendingBalance() {
        return this.lending != null ? Collections.unmodifiableMap(this.lending) : Collections.emptyMap();
    }

    public String toString() {
        return "PoloniexAvailableAccountBalance{exchange=" + this.exchange + ", margin=" + this.margin + ", lending=" + this.lending + '}';
    }

    public static enum ACCOUNT {
        EXCHANGE("exchange"),
        MARGIN("margin"),
        LENDING("lending");

        private String name;

        private ACCOUNT(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

